/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Defaults;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;

class RowCanvas
extends Component
implements AdjustmentListener,
FocusListener {
    Scrollbar hScroll;
    Scrollbar vScroll;
    int rowHeight;
    Vector rows = new Vector();
    int first;
    int xOffs;
    int xOffsInit;
    FontMetrics fm;
    int initVis = -1;

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n;
        Object object = adjustmentEvent.getSource();
        if (object == this.vScroll) {
            int n2 = adjustmentEvent.getValue();
            int n3 = this.first;
            if (n2 != this.first) {
                this.first = n2;
                this.shiftVertical(n3 - n2, false);
                this.vPosChange(n3 - n2);
            }
        } else if (object == this.hScroll && (n = -adjustmentEvent.getValue()) != this.xOffs + this.xOffsInit) {
            this.xOffs = n + this.xOffsInit;
            this.hPosChange();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.paintBorder();
        if (Defaults.FocusScrolls) {
            if (this.hScroll != null) {
                this.hScroll.setBackground(Defaults.FocusClr);
            }
            if (this.vScroll != null) {
                this.vScroll.setBackground(Defaults.FocusClr);
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.paintBorder();
        if (Defaults.FocusScrolls) {
            if (this.hScroll != null) {
                this.hScroll.setBackground(Defaults.BtnClr);
            }
            if (this.vScroll != null) {
                this.vScroll.setBackground(Defaults.BtnClr);
            }
        }
    }

    Graphics getClippedGraphics() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            int n = 2;
            graphics.clipRect(n, n, this.width - 2 * n, this.height - 2 * n);
        }
        return graphics;
    }

    int getRowIdx(int n) {
        int n2;
        int n3 = 2;
        if (n < 2) {
            for (int i = this.first - 1; i >= 0; --i) {
                if ((n3 -= this.rowHeight) >= n) continue;
                return i;
            }
            return 0;
        }
        int n4 = this.rows.size();
        for (n2 = this.first; n2 < n4 - 1 && (n3 += this.rowHeight) <= n; ++n2) {
        }
        return n2;
    }

    int getRowYPos(int n) {
        return 2 + (n - this.first) * this.rowHeight;
    }

    int getVisibleRows() {
        return (this.height - 4) / this.rowHeight;
    }

    void hPosChange() {
        this.repaint();
    }

    void innerLayout() {
        int n = this.parent.width;
        int n2 = this.parent.height;
        int n3 = Scrollbar.SCROLLBAR_WIDTH;
        boolean bl = this.vScroll != null && this.vScroll.isSliderShowing();
        boolean bl2 = this.hScroll != null && this.hScroll.isSliderShowing();
        this.setBounds(0, 0, bl ? n - n3 : n, bl2 ? n2 - n3 : n2);
        if (this.vScroll != null) {
            if (this.vScroll.isVisible() && !bl) {
                this.vScroll.setVisible(false);
            } else if (!this.vScroll.isVisible() && bl) {
                this.vScroll.setVisible(true);
            }
            this.vScroll.setBounds(n - n3, 0, n3, bl2 ? n2 - n3 : n2);
        }
        if (this.hScroll != null) {
            if (this.hScroll.isVisible() && !bl2) {
                this.hScroll.setVisible(false);
            } else if (!this.hScroll.isVisible() && bl2) {
                this.hScroll.setVisible(true);
            }
            this.hScroll.setBounds(0, n2 - n3, bl ? n - n3 : n, n3);
        }
        this.updateVScroll();
        if (this.initVis > -1) {
            this.makeVisible(this.initVis);
            this.initVis = -1;
        }
    }

    void makeVisible(int n) {
        int n2 = this.getVisibleRows();
        int n3 = this.rows.size();
        int n4 = n3 - n2;
        if (this.height == 0) {
            this.initVis = n;
            return;
        }
        if (n >= this.first && n < this.first + n2) {
            return;
        }
        if (n < 0) {
            n = 0;
        } else if (n >= n3) {
            n = n3 - 1;
        }
        int n5 = this.first;
        if (n < this.first) {
            this.first = n;
            this.shiftVertical(n5 - this.first, true);
        } else if (n > this.first + n2 - 1) {
            this.first = n - n2 + 1;
            this.shiftVertical(n5 - this.first, true);
        }
    }

    void repaintRow(Graphics graphics, int n) {
    }

    int repaintRows(Graphics graphics, int n, int n2) {
        int n3;
        int n4 = this.rows.size();
        int n5 = n3 = 2;
        for (int i = this.first; i < n4; ++i) {
            if (i >= n && i <= n + n2) {
                this.repaintRow(graphics, i);
            }
            if ((n5 += this.rowHeight) > this.height) break;
        }
        if (n5 < this.height) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(n3, n5, this.width - 2 * n3, this.height - n5 - n3);
        }
        return n5;
    }

    int repaintRows(int n, int n2) {
        Graphics graphics = this.getClippedGraphics();
        if (graphics == null) {
            return 0;
        }
        int n3 = this.repaintRows(graphics, n, n2);
        graphics.dispose();
        return n3;
    }

    void setListeners() {
        if (this.hScroll != null) {
            this.hScroll.addAdjustmentListener(this);
        }
        if (this.vScroll != null) {
            this.vScroll.addAdjustmentListener(this);
        }
        this.addFocusListener(this);
    }

    void shiftVertical(int n, boolean bl) {
        if (n == 0) {
            return;
        }
        Graphics graphics = this.getClippedGraphics();
        if (graphics == null) {
            return;
        }
        if (bl) {
            this.vScroll.setValue(this.first);
        }
        int n2 = 2;
        graphics.copyArea(n2, n2, this.width - 2 * n2, this.height - 2 * n2, 0, n * this.rowHeight);
        if (n < 0) {
            int n3 = this.first + this.getVisibleRows() + n;
            int n4 = -n + 1;
            this.repaintRows(graphics, n3, n4);
        } else {
            this.repaintRows(graphics, this.first, n - 1);
        }
        graphics.dispose();
    }

    void updateVScroll() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.vScroll != null) {
            bl = this.vScroll.isSliderShowing();
            int n = this.getVisibleRows();
            this.vScroll.setValues(this.first, n, 0, this.rows.size() - n);
            bl2 = this.vScroll.isSliderShowing();
        }
        if (bl != bl2) {
            Graphics graphics = this.parent.getGraphics();
            if (graphics != null) {
                graphics.setColor(this.parent.getBackground());
                graphics.fillRect(0, 0, this.parent.width, this.parent.height);
                graphics.dispose();
            }
            this.innerLayout();
        }
    }

    void vPosChange(int n) {
    }

    RowCanvas() {
    }
}

