/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Container;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.List;
import java.awt.Point;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class Choice
extends Container
implements ItemSelectable,
ActionListener,
ItemListener,
MouseListener,
KeyListener {
    Vector items = new Vector();
    Object selection;
    ItemListener iListener;
    ChoiceWindow prompter;
    TextField entry = new TextField();
    boolean hilight;
    static int BTN_WIDTH = 15;

    public Choice() {
        this.setLayout(null);
        this.setBackground(Color.lightGray);
        this.add(this.entry);
        this.entry.addActionListener(this);
        this.entry.addKeyListener(this);
        this.addMouseListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.select(actionEvent.getActionCommand());
    }

    public synchronized void add(String string) {
        this.addItem(string);
    }

    public synchronized void addItem(String string) {
        this.insert(string, this.items.size());
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.iListener = AWTEventMulticaster.add(this.iListener, itemListener);
        this.eventMask |= 0x200;
    }

    void closePrompt() {
        if (this.prompter != null) {
            this.prompter.list.removeItemListener(this);
            this.prompter.list.removeActionListener(this);
            this.prompter.dispose();
            this.prompter = null;
            this.repaint();
            this.entry.requestFocus();
        }
    }

    public void doLayout() {
        int n = 2;
        this.entry.setBounds(0, 0, this.width - BTN_WIDTH - 2 * n, this.height);
    }

    public String getItem(int n) {
        return (String)this.items.elementAt(n);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.entry.getPreferredSize();
        dimension.width += BTN_WIDTH;
        return dimension;
    }

    public int getSelectedIndex() {
        return this.items.indexOf(this.selection);
    }

    public synchronized String getSelectedItem() {
        return (String)this.selection;
    }

    public synchronized Object[] getSelectedObjects() {
        Object[] objectArray = this.selection != null ? new Object[]{this.selection} : new Object[]{};
        return objectArray;
    }

    public synchronized void insert(String string, int n) {
        if (this.items.size() == 0) {
            this.selection = string;
            this.entry.setText(string);
        }
        this.items.insertElementAt(string, n);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1 && this.prompter.list.selMouse) {
            this.select(this.prompter.list.getSelectedItem());
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 40) {
            this.openPrompt();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.hilight = true;
        this.paintButton();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.hilight = false;
        this.paintButton();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.prompter == null) {
            this.openPrompt();
        } else {
            this.closePrompt();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    void notifyItem() {
        if (this.hasToNotify(512, this.iListener)) {
            ItemEvent itemEvent = AWTEvent.getItemEvent(this, 0);
            ((AWTEvent)itemEvent).setItemEvent(this.selection, 1);
            Toolkit.eventQueue.postEvent(itemEvent);
        }
    }

    void openPrompt() {
        if (this.prompter != null) {
            return;
        }
        Frame frame = (Frame)this.entry.getToplevel();
        this.prompter = new ChoiceWindow(frame);
        Point point = this.getLocationOnScreen();
        this.prompter.popUpAt(point.x, point.y + this.height + 1, this.width, Math.min(this.items.size() + 1, 8) * Defaults.WndFontMetrics.getHeight());
        this.prompter.list.addItemListener(this);
        this.prompter.list.addActionListener(this);
        this.repaint();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintButton(graphics);
    }

    void paintButton() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paintButton(graphics);
            graphics.dispose();
        }
    }

    void paintButton(Graphics graphics) {
        int n = 2;
        int n2 = BTN_WIDTH;
        graphics.setColor(this.hilight ? Defaults.BtnPointClr : Defaults.BtnClr);
        graphics.fill3DRect(this.width - n2 - n, n, n2, this.height - 2 * n, this.prompter == null);
        int n3 = this.width - n - n2 / 2;
        int n4 = this.height - (this.height - 7) / 2;
        graphics.setColor(Color.white);
        graphics.drawLine(n3, n4, n3 - 3, n4 - 7);
        graphics.drawLine(n3, n4, n3 + 3, n4 - 7);
        graphics.setColor(this.hilight ? Defaults.FocusClr : Color.black);
        graphics.drawLine(--n3, n4, n3 - 3, n4 - 7);
        graphics.drawLine(n3, n4, n3 + 3, n4 - 7);
        graphics.setColor(Defaults.BtnClr);
        n3 = this.width - n2 - 2 * n;
        graphics.draw3DRect(n3, 0, this.width - n3 - 1, this.height - 1, true);
        graphics.draw3DRect(n3 + 1, 1, this.width - n3 - 3, this.height - 3, false);
    }

    protected String paramString() {
        return super.paramString();
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        this.iListener.itemStateChanged(itemEvent);
    }

    public synchronized void remove(String string) {
        this.items.removeElement(string);
    }

    public synchronized void removeAll() {
        this.items.removeAllElements();
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.iListener = AWTEventMulticaster.remove(this.iListener, itemListener);
    }

    public void requestFocus() {
        this.entry.requestFocus();
    }

    public synchronized void select(String string) {
        this.closePrompt();
        if (this.items.contains(string)) {
            this.selection = string;
            if (!this.entry.getText().equals(string)) {
                this.entry.setText(string);
            }
            this.notifyItem();
        }
    }

    public synchronized void select(int n) {
        this.select((String)this.items.elementAt(n));
    }

    class ChoiceWindow
    extends Window {
        List list = new List();

        public ChoiceWindow(Frame frame) {
            super(frame);
            this.setLayout(null);
            this.list.removeHScroll();
            this.add(this.list);
        }

        public void doLayout() {
            int n = 1;
            this.list.setBounds(n, n, this.width - 2 * n, this.height - 2 * n);
        }

        void popUpAt(int n, int n2, int n3, int n4) {
            int n5 = Choice.this.items.size();
            this.setBounds(n, n2, n3, n4);
            for (int i = 0; i < n5; ++i) {
                this.list.add((String)Choice.this.items.elementAt(i));
            }
            this.setVisible(true);
            this.list.select(Choice.this.items.indexOf(Choice.this.selection));
            this.list.requestFocus();
        }
    }
}

