/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

class TextCursor
extends Thread {
    private TextCanvas canvas;
    private boolean flash;
    private boolean undraw;
    private Rectangle r;

    public TextCursor(TextCanvas textCanvas) {
        this.canvas = textCanvas;
        this.r = new Rectangle();
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {}
            this.sync_draw();
        }
    }

    private synchronized void sync_draw() {
        if (this.flash) {
            this.draw_or_undraw();
        }
    }

    public boolean getUndraw() {
        return this.undraw;
    }

    public synchronized void pause_cursor(boolean bl) {
        if (this.undraw) {
            this.draw_or_undraw();
        }
        this.flash = false;
    }

    public synchronized void release_cursor(boolean bl) {
        if (!this.undraw) {
            this.draw_or_undraw();
        }
        this.flash = true;
    }

    private boolean draw_or_undraw() {
        Graphics graphics = this.canvas.getGraphics();
        if (graphics != null) {
            if (!this.undraw) {
                this.canvas.getCursorPos(graphics, this.r);
            }
            graphics.setXORMode(Color.white);
            graphics.drawLine(this.r.x, this.r.y, this.r.x, this.r.y + this.r.height);
            this.undraw = !this.undraw;
            graphics.dispose();
        }
        return this.undraw;
    }
}

