/*
 * Decompiled with CFR 0.152.
 */
package kaffe.net.www.protocol.system;

import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class SystemURLConnection
extends URLConnection {
    private static final String[] headers = new String[]{"content-encoding", "content-length", "content-type", "date", "expiration", "If-Modified-Since", "lastModified"};
    private String[] headersValue = new String[headers.length];
    private static final int ContentEncoding = 0;
    private static final int ContentLength = 1;
    private static final int ContentType = 2;
    private static final int Date = 3;
    private static final int Expiration = 4;
    private static final int IfModifiedSince = 5;
    private static final int LastModified = 6;
    private byte[] data;

    public SystemURLConnection(URL uRL) {
        super(uRL);
    }

    public void connect() throws IOException {
        String string = this.url.getFile();
        this.data = ClassLoader.getSystemResourceAsBytes0(string);
        this.headersValue[0] = URLConnection.fileNameMap.getContentTypeFor(string);
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            return null;
        }
        return new ByteArrayInputStream(this.data);
    }

    public Object getContent() throws IOException {
        if (this.headersValue[0] == null) {
            return null;
        }
        if (this.headersValue[0].equals("image/gif") || this.headersValue[0].equals("image/jpeg")) {
            return Toolkit.getDefaultToolkit().createImage(this.data);
        }
        return null;
    }

    public String getHeaderField(int n) {
        if (n < 0 || n >= this.headersValue.length) {
            return null;
        }
        return this.headersValue[n];
    }

    public String getHeaderField(String string) {
        for (int i = 0; i < headers.length; ++i) {
            if (string != headers[i]) continue;
            return this.getHeaderField(i);
        }
        return null;
    }

    public String getHeaderFieldKey(int n) {
        if (n < 0 || n >= headers.length) {
            return null;
        }
        return headers[n];
    }
}

