/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;

public final class StringCharacterIterator
implements CharacterIterator {
    private String text;
    private int pos;
    private int begin;
    private int end;

    public StringCharacterIterator(String string) {
        this(string, 0, string.length(), 0);
    }

    public StringCharacterIterator(String string, int n) {
        this(string, 0, string.length(), n);
    }

    public StringCharacterIterator(String string, int n, int n2, int n3) {
        this.text = string;
        this.pos = n3;
        this.begin = n;
        this.end = n2;
    }

    public char first() {
        this.pos = this.begin;
        return this.current();
    }

    public char last() {
        this.pos = this.end - 1;
        return this.current();
    }

    public char current() {
        if (this.pos < this.begin || this.pos >= this.end) {
            return '\uffff';
        }
        return this.text.charAt(this.pos);
    }

    public char next() {
        ++this.pos;
        return this.current();
    }

    public char previous() {
        --this.pos;
        return this.current();
    }

    public void setIndex(int n) {
        this.pos = n;
    }

    public int getBeginIndex() {
        return this.begin;
    }

    public int getEndIndex() {
        return this.end;
    }

    public int getIndex() {
        return this.pos;
    }

    public Object clone() {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(this.text, this.begin, this.end, this.pos);
        return stringCharacterIterator;
    }

    public boolean equals(Object object) {
        try {
            StringCharacterIterator stringCharacterIterator = (StringCharacterIterator)object;
            if (this.text.equals(stringCharacterIterator.text) && this.pos == stringCharacterIterator.pos && this.begin == stringCharacterIterator.begin && this.end == stringCharacterIterator.end) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

