/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Enumeration;
import java.util.Hashtable;
import kaffe.util.Deprecated;
import kaffe.util.Ptr;

public class Thread
implements Runnable {
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private static int threadCount = 0;
    private char[] name;
    private int priority;
    private Thread threadQ;
    private Ptr PrivateInfo;
    private boolean daemon;
    private boolean interrupting;
    private Runnable target;
    private ThreadGroup group;
    private Ptr exceptPtr;
    private Ptr exceptObj;
    private Ptr jnireferences;
    private boolean dying;
    private Hashtable threadLocals;

    public native int countStackFrames();

    public static native Thread currentThread();

    public static native void yield();

    public final native boolean isAlive();

    public synchronized native void start();

    private native void setPriority0(int var1);

    public Thread() {
        this(null, null, Thread.generateName());
    }

    public Thread(Runnable runnable) {
        this(null, runnable, Thread.generateName());
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable) {
        this(threadGroup, runnable, Thread.generateName());
    }

    public Thread(String string) {
        this(null, null, string);
    }

    public Thread(ThreadGroup threadGroup, String string) {
        this(threadGroup, null, string);
    }

    public Thread(Runnable runnable, String string) {
        this(null, runnable, string);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
        int n;
        int n2;
        Thread thread = Thread.currentThread();
        this.group = threadGroup == null ? thread.getThreadGroup() : threadGroup;
        this.group.checkAccess();
        this.group.add(this);
        this.name = string.toCharArray();
        this.target = runnable;
        this.interrupting = false;
        if (thread.threadLocals != null) {
            Enumeration enumeration = thread.threadLocals.keys();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                if (!(object instanceof InheritableThreadLocal)) continue;
                InheritableThreadLocal inheritableThreadLocal = (InheritableThreadLocal)object;
                inheritableThreadLocal.set(this, inheritableThreadLocal.childValue(inheritableThreadLocal.get()));
            }
        }
        if ((n2 = thread.getPriority()) < (n = this.group.getMaxPriority())) {
            this.setPriority0(n2);
        } else {
            this.setPriority0(n);
        }
        this.setDaemon(thread.isDaemon());
    }

    private static String generateName() {
        return new String(String.valueOf("Thread-").concat(String.valueOf(threadCount++)));
    }

    public static void sleep(long l, int n) throws InterruptedException {
        Thread.sleep(l);
    }

    public static void sleep(long l) throws InterruptedException {
        Thread.sleep0(l);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    private void finish() {
        if (this.group != null) {
            this.group.remove(this);
        }
    }

    public final void stop() {
        throw new Deprecated();
    }

    public final synchronized void stop(Throwable throwable) {
        throw new Deprecated();
    }

    public void interrupt() {
        this.interrupting = true;
        this.interrupt0();
    }

    public static boolean interrupted() {
        boolean bl = Thread.currentThread().interrupting;
        Thread.currentThread().interrupting = false;
        return bl;
    }

    public boolean isInterrupted() {
        return this.interrupting;
    }

    public void destroy() {
        this.destroy0();
    }

    public final void suspend() {
        throw new Deprecated();
    }

    public final void resume() {
        throw new Deprecated();
    }

    public final void setPriority(int n) {
        this.checkAccess();
        if (n < 1 || n > this.group.getMaxPriority()) {
            throw new IllegalArgumentException();
        }
        this.setPriority0(n);
    }

    public final int getPriority() {
        return this.priority;
    }

    public final void setName(String string) {
        this.name = string.toCharArray();
    }

    public final String getName() {
        return new String(this.name);
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public static int enumerate(Thread[] threadArray) {
        return Thread.currentThread().getThreadGroup().enumerate(threadArray);
    }

    public final synchronized void join(long l) throws InterruptedException {
        this.join(l, 0);
    }

    public final synchronized void join(long l, int n) throws InterruptedException {
        if (l == 0L && n == 0) {
            while (this.isAlive()) {
                this.wait(0L);
            }
        } else {
            long l2 = System.currentTimeMillis();
            while (this.isAlive() && System.currentTimeMillis() < l + l2) {
                long l3 = l + l2 - System.currentTimeMillis();
                this.wait(l3);
            }
        }
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public static void dumpStack() {
        Throwable throwable = new Throwable();
        throwable.printStackTrace();
    }

    public final void setDaemon(boolean bl) {
        this.daemon = bl;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public void checkAccess() {
        System.getSecurityManager().checkAccess(this);
    }

    public String toString() {
        return this.getName();
    }

    Hashtable getThreadLocals() {
        if (this.threadLocals == null) {
            this.threadLocals = new Hashtable();
        }
        return this.threadLocals;
    }

    private static native void sleep0(long var0);

    private native void interrupt0();

    private native void destroy0();
}

