/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public class PixelGrabber
implements ImageConsumer {
    int x;
    int y;
    int width;
    int height;
    ColorModel model;
    ImageProducer producer;
    int[] pels;
    int off;
    int scan;
    int status;
    boolean active;
    Rectangle updRect = new Rectangle();

    public PixelGrabber(Image image, int n, int n2, int n3, int n4, boolean bl) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.producer = image.getSource();
        this.model = bl ? ColorModel.getRGBdefault() : null;
    }

    public PixelGrabber(Image image, int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        this(image.getSource(), n, n2, n3, n4, nArray, n5, n6);
    }

    public PixelGrabber(ImageProducer imageProducer, int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        this.producer = imageProducer;
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.pels = nArray;
        this.off = n5;
        this.scan = n6;
        this.model = ColorModel.getRGBdefault();
    }

    public synchronized void abortGrabbing() {
        this.imageComplete(4);
    }

    public synchronized ColorModel getColorModel() {
        return this.model;
    }

    public synchronized int getHeight() {
        return this.height;
    }

    public synchronized Object getPixels() {
        return this.pels;
    }

    public synchronized int getStatus() {
        return this.status;
    }

    int getUpdateRect(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (n2 < this.y) {
            n7 = this.y - n2;
            n5 += n6 * n7;
            n2 += n7;
            if ((n4 -= n7) <= 0) {
                return -1;
            }
        }
        if (n2 + n4 > this.y + this.height && (n4 = this.y + this.height - n2) <= 0) {
            return -1;
        }
        if (n < this.x) {
            n7 = this.x - n;
            n5 += n7;
            n += n7;
            if ((n3 -= n7) <= 0) {
                return -1;
            }
        }
        if (n + n3 > this.x + this.width && (n3 = this.x + this.width - n) <= 0) {
            return -1;
        }
        this.updRect.setBounds(n, n2, n3, n4);
        return n5;
    }

    public synchronized int getWidth() {
        return this.width;
    }

    public boolean grabPixels() throws InterruptedException {
        if (!this.active) {
            this.startGrabbing();
        }
        while (this.active) {
            this.wait(0L);
        }
        return (this.status & 0x30) != 0;
    }

    public synchronized boolean grabPixels(long l) throws InterruptedException {
        long l2;
        if (l <= 0L) {
            return this.grabPixels();
        }
        if (!this.active) {
            this.startGrabbing();
        }
        long l3 = System.currentTimeMillis() + l;
        while (this.active && (l2 = l3 - System.currentTimeMillis()) > 0L) {
            this.wait(l2);
        }
        return (this.status & 0x30) != 0;
    }

    public synchronized void imageComplete(int n) {
        switch (n) {
            case 1: {
                this.status |= 0x40;
                break;
            }
            case 2: {
                this.status |= 0x10;
                break;
            }
            case 3: {
                this.status |= 0x20;
                break;
            }
            case 4: {
                this.status |= 0x80;
            }
        }
        this.active = false;
        this.producer.removeConsumer(this);
        this.notifyAll();
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public void setDimensions(int n, int n2) {
        if (this.width == -1) {
            this.width = n - this.x;
        }
        if (this.height == -1) {
            this.height = n2 - this.y;
        }
        if (this.pels == null) {
            this.pels = new int[this.width * this.height];
            this.scan = this.width;
            this.off = 0;
        }
        this.status |= 3;
    }

    public void setHints(int n) {
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if ((n5 = this.getUpdateRect(n, n2, n3, n4, n5, n6)) < 0) {
            return;
        }
        int n7 = this.off + (this.updRect.y - this.y) * this.scan + (this.updRect.x - this.x);
        while (this.updRect.height > 0) {
            System.arraycopy(nArray, n5, this.pels, n7, this.updRect.width);
            n5 += n6;
            n7 += this.scan;
            --this.updRect.height;
        }
        this.status |= 8;
    }

    public void setProperties(Hashtable hashtable) {
        this.status |= 4;
    }

    public synchronized void startGrabbing() {
        if (!this.active) {
            this.active = true;
            this.status = 0;
            this.producer.startProduction(this);
        }
    }
}

