/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import kaffe.awt.OpaqueComponent;

public abstract class Container
extends Component {
    Component[] children;
    int nChildren;
    LayoutManager layout = dummyLayout;
    boolean isLayouting;
    ContainerListener cntrListener;
    Insets insets = Insets.noInsets;
    private static LayoutManager dummyLayout = new FlowLayout();

    protected Container() {
    }

    public Component add(Component component) {
        this.addImpl(component, null, -1);
        return component;
    }

    public void add(Component component, Object object) {
        this.addImpl(component, object, -1);
    }

    public void add(Component component, Object object, int n) {
        this.addImpl(component, object, n);
    }

    public Component add(Component component, int n) {
        this.addImpl(component, null, n);
        return component;
    }

    public Component add(String string, Component component) {
        this.addImpl(component, string, -1);
        if (this.layout != null) {
            this.layout.addLayoutComponent(string, component);
        }
        return component;
    }

    public void addContainerListener(ContainerListener containerListener) {
        this.cntrListener = AWTEventMulticaster.add(this.cntrListener, containerListener);
        this.eventMask |= 2;
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component.parent != null) {
            component.parent.remove(component);
        }
        if (this.children == null) {
            this.children = new Component[3];
        } else if (this.nChildren == this.children.length) {
            Component[] componentArray = this.children;
            this.children = new Component[this.nChildren * 2];
            System.arraycopy(componentArray, 0, this.children, 0, this.nChildren);
        }
        if (n < 0 || this.nChildren == 0 || n == this.nChildren) {
            this.children[this.nChildren] = component;
        } else if (n < this.nChildren) {
            System.arraycopy(this.children, n, this.children, n + 1, this.nChildren - n);
            this.children[n] = component;
        }
        ++this.nChildren;
        component.parent = this;
        if (this.layout == dummyLayout) {
            this.layout = this.getDefaultLayout();
        }
        if (this.layout != null && this.layout instanceof LayoutManager2) {
            ((LayoutManager2)this.layout).addLayoutComponent(component, object);
        }
        if (this.hasToNotify(2, this.cntrListener)) {
            Toolkit.eventQueue.postEvent(new ContainerEvent(this, 300, component));
        }
    }

    public void addNotify() {
        super.addNotify();
        for (int i = 0; i < this.nChildren; ++i) {
            this.children[i].addNotify();
        }
    }

    Graphics clipSiblings(Component component, Graphics graphics) {
        int n;
        int n2 = graphics.clip.x + graphics.xOffset;
        int n3 = graphics.clip.y + graphics.yOffset;
        int n4 = n2 + graphics.clip.width;
        int n5 = n3 + graphics.clip.height;
        for (n = this.nChildren - 1; n >= 0 && this.children[n] != component; --n) {
        }
        --n;
        while (n >= 0) {
            Component component2 = this.children[n];
            int n6 = component2.x + component2.width;
            int n7 = component2.y + component2.height;
            if (component2.x > n4 || component2.y > n5 || n6 < n2 || n7 < n3) {
                // empty if block
            }
            --n;
        }
        return graphics;
    }

    public void doLayout() {
        if (this.layout != null && this.nChildren > 0 && !this.isLayouting) {
            this.isLayouting = true;
            this.layout.layoutContainer(this);
            this.isLayouting = false;
            if (this.isShowing()) {
                if (this.parent != null) {
                    if (!this.parent.isLayouting) {
                        if (this instanceof OpaqueComponent) {
                            this.repaint();
                        } else {
                            this.parent.repaint(this.x, this.y, this.width, this.height);
                        }
                    }
                } else {
                    this.repaint();
                }
            }
        }
    }

    public float getAlignmentX() {
        if (this.layout instanceof LayoutManager2) {
            return ((LayoutManager2)this.layout).getLayoutAlignmentX(this);
        }
        return super.getAlignmentX();
    }

    public float getAlignmentY() {
        if (this.layout instanceof LayoutManager2) {
            return ((LayoutManager2)this.layout).getLayoutAlignmentY(this);
        }
        return super.getAlignmentY();
    }

    public Component getComponent(int n) {
        return this.children[n];
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    public Component getComponentAt(int n, int n2) {
        if (!this.isShowing() || n < 0 || n > this.x + this.width || n2 < 0 || n2 > this.y + this.height) {
            return null;
        }
        for (int i = 0; i < this.nChildren; ++i) {
            Component component = this.children[i];
            if (!component.contains(n - component.x, n2 - component.y)) continue;
            return component.isShowing() ? component : this;
        }
        return this;
    }

    public int getComponentCount() {
        return this.nChildren;
    }

    public Component[] getComponents() {
        Component[] componentArray = new Component[this.nChildren];
        if (this.nChildren > 0) {
            System.arraycopy(this.children, 0, componentArray, 0, this.nChildren);
        }
        return componentArray;
    }

    LayoutManager getDefaultLayout() {
        return null;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public LayoutManager getLayout() {
        return this.layout;
    }

    public Dimension getMaximumSize() {
        if (this.layout != null && this.layout instanceof LayoutManager2) {
            return ((LayoutManager2)this.layout).maximumLayoutSize(this);
        }
        return super.getMaximumSize();
    }

    public Dimension getMinimumSize() {
        if (this.layout != null) {
            return this.layout.minimumLayoutSize(this);
        }
        return super.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        if (this.layout != null) {
            return this.layout.preferredLayoutSize(this);
        }
        return super.getPreferredSize();
    }

    public Insets insets() {
        return this.getInsets();
    }

    public boolean isAncestorOf(Component component) {
        component = component.parent;
        while (component != null) {
            if (component == this) {
                return true;
            }
            component = component.parent;
        }
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Rectangle rectangle = graphics.clip;
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = n + rectangle.width;
        int n4 = n2 + rectangle.height;
        Font font = graphics.fnt;
        Color color = graphics.fg;
        Color color2 = graphics.bg;
        for (int i = this.nChildren - 1; i >= 0; --i) {
            Component component = this.children[i];
            if (!component.isVisible) continue;
            int n5 = component.x;
            int n6 = component.y;
            int n7 = n5 + component.width;
            int n8 = n6 + component.height;
            if (n7 < n || n8 < n2 || n3 < n5 || n4 < n6) continue;
            int n9 = n < n5 ? 0 : n - n5;
            int n10 = n2 < n6 ? 0 : n2 - n6;
            int n11 = (n3 < n7 ? n3 : n7) - n5 - n9;
            int n12 = (n4 < n8 ? n4 : n8) - n6 - n10;
            graphics.translate(n5, n6);
            graphics.setClip(n9, n10, n11, n12);
            if (component.font != null) {
                graphics.setFont(component.font);
            }
            if (component.fgClr != null) {
                graphics.setColor(component.fgClr);
            }
            if (component.bgClr != null) {
                graphics.setBackColor(component.bgClr);
            }
            component.paint(graphics);
            graphics.translate(-n5, -n6);
            graphics.setFont(font);
            graphics.setColor(color);
            graphics.setBackColor(color2);
        }
        graphics.setClip(n, n2, n3 - n, n4 - n2);
    }

    public void printComponents(Graphics graphics) {
    }

    public void processContainerEvent(ContainerEvent containerEvent) {
        if (this.hasToNotify(2, this.cntrListener)) {
            switch (containerEvent.getID()) {
                case 300: {
                    this.cntrListener.componentAdded(containerEvent);
                    break;
                }
                case 301: {
                    this.cntrListener.componentRemoved(containerEvent);
                }
            }
        }
    }

    public void remove(Component component) {
        for (int i = this.nChildren - 1; i >= 0; --i) {
            if (this.children[i] != component) continue;
            this.remove(i);
            break;
        }
    }

    public void remove(int n) {
        int n2 = this.nChildren - 1;
        if (n < 0 && n > n2) {
            return;
        }
        Component component = this.children[n];
        if (this.layout != null) {
            this.layout.removeLayoutComponent(component);
        }
        if (n < n2 && n > -1) {
            System.arraycopy(this.children, n + 1, this.children, n, n2 - n);
        }
        this.children[n2] = null;
        --this.nChildren;
        component.removeNotify();
        if (this.hasToNotify(2, this.cntrListener)) {
            Toolkit.eventQueue.postEvent(new ContainerEvent(this, 301, component));
        }
        this.doLayout();
    }

    public void removeAll() {
        for (int i = this.nChildren - 1; i >= 0; --i) {
            Component component = this.children[i];
            component.removeNotify();
            if (this.layout != null) {
                this.layout.removeLayoutComponent(component);
            }
            this.children[i] = null;
            if ((this.eventMask & 2) == 0 || this.cntrListener == null) continue;
            this.cntrListener.componentRemoved(new ContainerEvent(this, 301, component));
        }
        this.nChildren = 0;
        this.repaint();
    }

    public void removeContainerListener(ContainerListener containerListener) {
        this.cntrListener = AWTEventMulticaster.remove(this.cntrListener, containerListener);
    }

    public void removeNotify() {
        for (int i = 0; i < this.nChildren; ++i) {
            this.children[i].removeNotify();
        }
        super.removeNotify();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (int i = 0; i < this.nChildren; ++i) {
            this.children[i].setEnabled(bl);
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        this.layout = layoutManager;
        if (this.layout != null && this.nChildren > 0) {
            this.doLayout();
        }
    }

    protected void validateTree() {
        this.doLayout();
    }
}

