/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Adjustable;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Defaults;
import java.awt.HotKeyHandler;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupWindow;
import java.awt.Rectangle;
import java.awt.RootWindow;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import kaffe.util.Ptr;

public class AWTEvent
extends EventObject {
    protected int id;
    protected boolean consumed = false;
    protected AWTEvent next;
    public static final int COMPONENT_EVENT_MASK = 1;
    public static final int CONTAINER_EVENT_MASK = 2;
    public static final int FOCUS_EVENT_MASK = 4;
    public static final int KEY_EVENT_MASK = 8;
    public static final int MOUSE_EVENT_MASK = 16;
    public static final int MOUSE_MOTION_EVENT_MASK = 32;
    public static final int WINDOW_EVENT_MASK = 64;
    public static final int ACTION_EVENT_MASK = 128;
    public static final int ADJUSTMENT_EVENT_MASK = 256;
    public static final int ITEM_EVENT_MASK = 512;
    public static final int TEXT_EVENT_MASK = 1024;
    public static final int RESERVED_ID_MAX = 1999;
    static final int DISABLED_MASK = Integer.MIN_VALUE;
    protected static int inputModifier;
    protected static final int BUTTON_MASK = 28;
    protected static boolean buttonPressed;
    protected static boolean mouseDragged;
    protected static int clickInterval;
    protected static Point mousePos;
    protected static Component mouseTgt;
    protected static int xMouseTgt;
    protected static int yMouseTgt;
    static Component[] cFrom;
    static Component[] cTo;
    protected static Component keyTgt;
    protected static Component keyTgtRequest;
    protected static Window activeWindow;
    protected static Window newActiveWindow;
    protected static FocusEvent focusEvtCache;
    protected static KeyEvent keyEvtCache;
    protected static MouseEvent mouseEvtCache;
    protected static PaintEvent paintEvtCache;
    protected static ComponentEvent cmpEvtCache;
    protected static WindowEvent wndEvtCache;
    protected static ActionEvent actEvtCache;
    protected static ItemEvent itmEvtCache;
    protected static AdjustmentEvent adjEvtCache;
    protected static boolean accelHint;
    protected static Component[] sources;
    static int nSources;
    protected static Object evtLock;
    protected static RootWindow root;
    protected static Window popup;

    protected AWTEvent(Object object, int n) {
        super(object);
        this.id = n;
    }

    protected static void checkActiveWindow(Component component) {
        Component component2 = component.getToplevel();
        if (component2 != activeWindow && component2 != null) {
            FocusEvent focusEvent = AWTEvent.getFocusEvent(component2, 1004);
            ((AWTEvent)focusEvent).dispatch();
        }
    }

    protected static void checkMouseTransfer(Component component) {
        Component component2 = mouseTgt;
        int n = AWTEvent.mousePos.x;
        int n2 = AWTEvent.mousePos.y;
        if (component2 != null) {
            while (component2.parent != null) {
                n += component2.x;
                n2 += component2.y;
                component2 = component2.parent;
            }
            n += component2.x;
            n2 += component2.y;
        }
        if (component.contains(n -= component.x, n2 -= component.y)) {
            AWTEvent.sendMouseEnterEvent(component, n, n2, false);
        }
    }

    protected static boolean checkPopup(Object object) {
        if (popup == null) {
            return true;
        }
        if (object instanceof PopupWindow && ((PopupWindow)object).rootWnd() == popup) {
            return true;
        }
        popup.dispose();
        popup = null;
        return false;
    }

    protected static void clickToFocus(Component component) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Component computeMouseTarget(Container container, int n, int n2) {
        Container container2;
        int n3;
        int n4;
        if (mouseTgt != null) {
            n4 = n - xMouseTgt;
            n3 = n2 - yMouseTgt;
            if (mouseTgt.contains(n4, n3)) {
                if (!(mouseTgt instanceof Container)) return mouseTgt;
                container2 = (Container)mouseTgt;
                n = n4;
                n2 = n3;
            } else {
                container2 = container;
                xMouseTgt = 0;
                yMouseTgt = 0;
            }
        } else {
            container2 = container;
            xMouseTgt = 0;
            yMouseTgt = 0;
        }
        if (container2.insets != Insets.noInsets && (n >= container2.width - container2.insets.right || n2 >= container2.height - container2.insets.bottom)) {
            return container2;
        }
        if (!container2.isVisible) {
            return null;
        }
        int n5 = 0;
        while (n5 < container2.nChildren) {
            Component component = container2.children[n5];
            n4 = n - component.x;
            n3 = n2 - component.y;
            if (component.contains(n4, n3)) {
                xMouseTgt += component.x;
                yMouseTgt += component.y;
                if (!(component instanceof Container)) return component;
                n = n4;
                n2 = n3;
                container2 = (Container)component;
                n5 = 0;
                continue;
            }
            ++n5;
        }
        return container2;
    }

    public void consume() {
        this.consumed = true;
    }

    protected void dispatch() {
        ((Component)this.source).dispatchEventImpl(this);
    }

    protected static ActionEvent getActionEvent(Object object, int n) {
        Object object2 = evtLock;
        synchronized (object2) {
            ActionEvent actionEvent;
            try {
                if (actEvtCache == null) {
                    ActionEvent actionEvent2 = new ActionEvent(object, n, null);
                    Object var6_5 = null;
                    return actionEvent2;
                }
                ActionEvent actionEvent3 = actEvtCache;
                actEvtCache = (ActionEvent)actionEvent3.next;
                actionEvent3.next = null;
                actionEvent3.source = object;
                actionEvent3.id = n;
                actionEvent = actionEvent3;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                throw throwable;
            }
            Object var6_6 = null;
            return actionEvent;
        }
    }

    protected static AdjustmentEvent getAdjustmentEvent(Adjustable adjustable, int n) {
        Object object = evtLock;
        synchronized (object) {
            AdjustmentEvent adjustmentEvent;
            try {
                if (adjEvtCache == null) {
                    AdjustmentEvent adjustmentEvent2 = new AdjustmentEvent(adjustable, n, 0, 0);
                    Object var6_5 = null;
                    return adjustmentEvent2;
                }
                AdjustmentEvent adjustmentEvent3 = adjEvtCache;
                adjEvtCache = (AdjustmentEvent)adjustmentEvent3.next;
                adjustmentEvent3.next = null;
                adjustmentEvent3.source = adjustable;
                adjustmentEvent3.id = n;
                adjustmentEvent = adjustmentEvent3;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                throw throwable;
            }
            Object var6_6 = null;
            return adjustmentEvent;
        }
    }

    protected static ComponentEvent getComponentEvent(Component component, int n) {
        Object object = evtLock;
        synchronized (object) {
            ComponentEvent componentEvent;
            try {
                if (cmpEvtCache == null) {
                    ComponentEvent componentEvent2 = new ComponentEvent(component, n);
                    Object var6_5 = null;
                    return componentEvent2;
                }
                ComponentEvent componentEvent3 = cmpEvtCache;
                cmpEvtCache = (ComponentEvent)componentEvent3.next;
                componentEvent3.next = null;
                componentEvent3.source = component;
                componentEvent3.id = n;
                componentEvent = componentEvent3;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                throw throwable;
            }
            Object var6_6 = null;
            return componentEvent;
        }
    }

    protected static FocusEvent getFocusEvent(Component component, int n) {
        Object object = evtLock;
        synchronized (object) {
            FocusEvent focusEvent;
            try {
                if (focusEvtCache == null) {
                    FocusEvent focusEvent2 = new FocusEvent(component, n);
                    Object var6_5 = null;
                    return focusEvent2;
                }
                FocusEvent focusEvent3 = focusEvtCache;
                focusEvtCache = (FocusEvent)focusEvent3.next;
                focusEvent3.source = component;
                focusEvent3.id = n;
                focusEvent3.next = null;
                focusEvent = focusEvent3;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                throw throwable;
            }
            Object var6_6 = null;
            return focusEvent;
        }
    }

    public int getID() {
        return this.id;
    }

    static int getID(AWTEvent aWTEvent) {
        return aWTEvent.id;
    }

    protected static ItemEvent getItemEvent(ItemSelectable itemSelectable, int n) {
        Object object = evtLock;
        synchronized (object) {
            ItemEvent itemEvent;
            try {
                if (itmEvtCache == null) {
                    ItemEvent itemEvent2 = new ItemEvent(itemSelectable, n, null, 0);
                    Object var6_5 = null;
                    return itemEvent2;
                }
                ItemEvent itemEvent3 = itmEvtCache;
                itmEvtCache = (ItemEvent)itemEvent3.next;
                itemEvent3.next = null;
                itemEvent3.source = itemSelectable;
                itemEvent3.id = n;
                itemEvent = itemEvent3;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                throw throwable;
            }
            Object var6_6 = null;
            return itemEvent;
        }
    }

    protected static MouseEvent getMouseEvent(Component component, int n, long l, int n2, int n3, int n4, int n5, boolean bl) {
        Object object = evtLock;
        synchronized (object) {
            MouseEvent mouseEvent;
            try {
                if (mouseEvtCache == null) {
                    MouseEvent mouseEvent2 = new MouseEvent(component, n, l, n2, n3, n4, n5, bl);
                    Object var13_11 = null;
                    return mouseEvent2;
                }
                MouseEvent mouseEvent3 = mouseEvtCache;
                mouseEvtCache = (MouseEvent)mouseEvent3.next;
                mouseEvent3.next = null;
                mouseEvent3.source = component;
                mouseEvent3.id = n;
                ((AWTEvent)mouseEvent3).setMouseEvent(l, n2, n3, n4, n5, bl);
                mouseEvent = mouseEvent3;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                throw throwable;
            }
            Object var13_12 = null;
            return mouseEvent;
        }
    }

    protected static PaintEvent getPaintEvent(Component component, int n, Rectangle rectangle) {
        Object object = evtLock;
        synchronized (object) {
            PaintEvent paintEvent;
            try {
                if (paintEvtCache == null) {
                    PaintEvent paintEvent2 = new PaintEvent(component, n, rectangle);
                    Object var7_6 = null;
                    return paintEvent2;
                }
                PaintEvent paintEvent3 = paintEvtCache;
                paintEvtCache = (PaintEvent)paintEvent3.next;
                paintEvent3.next = null;
                paintEvent3.source = component;
                paintEvent3.id = n;
                paintEvent3.setUpdateRect(rectangle);
                paintEvent = paintEvent3;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                throw throwable;
            }
            Object var7_7 = null;
            return paintEvent;
        }
    }

    static Object getSource(AWTEvent aWTEvent) {
        return aWTEvent.source;
    }

    protected static Component getToplevel(Component component) {
        while (!(component instanceof Window)) {
            component = component.parent;
        }
        return component;
    }

    protected static WindowEvent getWindowEvent(Window window, int n) {
        Object object = evtLock;
        synchronized (object) {
            WindowEvent windowEvent;
            try {
                if (wndEvtCache == null) {
                    WindowEvent windowEvent2 = new WindowEvent(window, n);
                    Object var6_5 = null;
                    return windowEvent2;
                }
                WindowEvent windowEvent3 = wndEvtCache;
                wndEvtCache = (WindowEvent)windowEvent3.next;
                windowEvent3.source = window;
                windowEvent3.id = n;
                windowEvent3.next = null;
                windowEvent = windowEvent3;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                throw throwable;
            }
            Object var6_6 = null;
            return windowEvent;
        }
    }

    protected static void grabMouseDrag(Window window) {
        if (mouseTgt != null && buttonPressed) {
            if (mouseTgt instanceof PopupWindow) {
                xMouseTgt += window.x - AWTEvent.mouseTgt.x;
                yMouseTgt += window.y - AWTEvent.mouseTgt.y;
            } else {
                Component component = mouseTgt;
                while (component.parent != null) {
                    component = component.parent;
                }
                xMouseTgt = window.x - component.x;
                yMouseTgt = window.y - component.y;
                component.setNativeCursor(window.cursor);
            }
            mouseTgt = window;
            mouseDragged = true;
        }
    }

    protected boolean isConsumed() {
        return this.consumed;
    }

    public String paramString() {
        return "";
    }

    protected static void processActionEvent(ActionEvent actionEvent) {
        Object object = actionEvent.source;
        if (object instanceof Component) {
            ((Component)object).processActionEvent(actionEvent);
        } else if (object instanceof MenuItem) {
            ((MenuItem)object).processActionEvent(actionEvent);
        }
    }

    protected static void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        ((Component)adjustmentEvent.source).processAdjustmentEvent(adjustmentEvent);
    }

    protected static void processComponentEvent(ComponentEvent componentEvent) {
        ((Component)componentEvent.source).processComponentEvent(componentEvent);
    }

    protected static void processContainerEvent(ContainerEvent containerEvent) {
        ((Component)containerEvent.source).processContainerEvent(containerEvent);
    }

    protected static void processFocusEvent(FocusEvent focusEvent) {
        ((Component)focusEvent.source).processFocusEvent(focusEvent);
    }

    protected static void processItemEvent(ItemEvent itemEvent) {
        Object object = itemEvent.source;
        if (object instanceof Component) {
            ((Component)object).processItemEvent(itemEvent);
        } else if (object instanceof CheckboxMenuItem) {
            ((CheckboxMenuItem)object).processItemEvent(itemEvent);
        }
    }

    protected static void processKeyEvent(KeyEvent keyEvent) {
        ((Component)keyEvent.source).processKeyEvent(keyEvent);
        if (!keyEvent.consumed) {
            HotKeyHandler.handle(keyEvent);
        }
    }

    protected static void processMouseEvent(MouseEvent mouseEvent) {
        ((Component)mouseEvent.source).processMouseEvent(mouseEvent);
    }

    protected static void processMouseMotionEvent(MouseEvent mouseEvent) {
        ((Component)mouseEvent.source).processMouseMotionEvent(mouseEvent);
    }

    protected static void processPaintEvent(PaintEvent paintEvent) {
        ((Component)paintEvent.source).processPaintEvent(paintEvent);
    }

    protected static void processWindowEvent(WindowEvent windowEvent) {
        ((Component)windowEvent.source).processWindowEvent(windowEvent);
    }

    protected void recycle() {
        this.source = null;
        this.next = null;
    }

    static void registerSource(Component component, Ptr ptr) {
        int n = Toolkit.evtRegisterSource(ptr);
        AWTEvent.sources[n] = component;
        if (++nSources == 1) {
            Toolkit.startDispatch();
        }
    }

    static void resetPopup(Window window) {
        if (popup != null && popup == window) {
            popup = null;
        }
    }

    protected static void revertDragGrab(Component component) {
        if (mouseDragged) {
            xMouseTgt += component.x - AWTEvent.mouseTgt.x;
            yMouseTgt += component.y - AWTEvent.mouseTgt.y;
            mouseTgt = component;
        }
    }

    protected static void sendFocusEvent(Component component, boolean bl, boolean bl2) {
        int n = bl ? 1004 : 1005;
        FocusEvent focusEvent = AWTEvent.getFocusEvent(component, n);
        if (bl2) {
            ((AWTEvent)focusEvent).dispatch();
        } else {
            Toolkit.eventQueue.postEvent(focusEvent);
        }
    }

    protected static void sendMouseEnterEvent(Component component, int n, int n2, boolean bl) {
        MouseEvent mouseEvent = AWTEvent.getMouseEvent(component, 504, System.currentTimeMillis(), 0, n, n2, 0, false);
        if (bl) {
            ((AWTEvent)mouseEvent).dispatch();
        } else {
            Toolkit.eventQueue.postEvent(mouseEvent);
        }
    }

    protected static void sendPaintEvent(Component component, Rectangle rectangle, boolean bl) {
        PaintEvent paintEvent = AWTEvent.getPaintEvent(component, 800, rectangle);
        if (bl) {
            ((AWTEvent)paintEvent).dispatch();
        } else {
            Toolkit.eventQueue.postEvent(paintEvent);
        }
    }

    protected static void sendWindowEvent(Window window, int n, boolean bl) {
        WindowEvent windowEvent = AWTEvent.getWindowEvent(window, n);
        if (bl) {
            ((AWTEvent)windowEvent).dispatch();
        } else {
            Toolkit.eventQueue.postEvent(windowEvent);
        }
    }

    protected void setActionEvent(String string, int n) {
    }

    protected void setAdjustmentEvent(int n, int n2) {
    }

    protected void setItemEvent(Object object, int n) {
    }

    protected void setMouseEvent(long l, int n, int n2, int n3, int n4, boolean bl) {
    }

    static void setPopup(Window window) {
        if (popup != null) {
            popup.dispose();
        }
        popup = window;
    }

    void setSource(Object object) {
        this.source = object;
    }

    protected void setXY(int n, int n2) {
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.getClass().getName()).concat(String.valueOf(':'))).concat(String.valueOf(this.paramString()))).concat(String.valueOf(", source: "))).concat(String.valueOf(this.source));
    }

    protected static void transferMouse(MouseEvent mouseEvent, Component component, int n, int n2, Component component2, int n3, int n4) {
        int n5;
        int n6 = n;
        int n7 = n2;
        Object object = mouseEvent.source;
        int n8 = mouseEvent.id;
        int n9 = mouseEvent.getX();
        int n10 = mouseEvent.getY();
        int n11 = 0;
        AWTEvent.cFrom[0] = component;
        while (component != null) {
            AWTEvent.cFrom[++n11] = component;
            component = component.parent;
        }
        int n12 = 0;
        AWTEvent.cTo[0] = component2;
        while (component2 != null) {
            AWTEvent.cTo[++n12] = component2;
            component2 = component2.parent;
        }
        while (cFrom[n11] == (component2 = cTo[n12])) {
            AWTEvent.cTo[n12] = null;
            AWTEvent.cFrom[n11] = null;
            --n11;
            --n12;
        }
        mouseEvent.id = 505;
        for (n5 = 1; n5 <= n11; ++n5) {
            ((AWTEvent)mouseEvent).setXY(n6, n7);
            component = cFrom[n5];
            mouseEvent.source = component;
            component.processMouseEvent(mouseEvent);
            n6 += component.x;
            n7 += component.y;
        }
        mouseEvent.id = 504;
        if (cFrom[n11] != cTo[n12]) {
            n6 = n3;
            n7 = n4;
            for (n5 = 1; n5 <= n12; ++n5) {
                n6 += AWTEvent.cTo[n5].x;
                n7 += AWTEvent.cTo[n5].y;
            }
        }
        for (n5 = n12; n5 > 0; --n5) {
            component2 = cTo[n5];
            mouseEvent.source = component2;
            ((AWTEvent)mouseEvent).setXY(n6 -= component2.x, n7 -= component2.y);
            component2.processMouseEvent(mouseEvent);
        }
        if (component2 != null) {
            component2.setCursor(component2.cursor);
        }
        for (n5 = 0; n5 < n11; ++n5) {
            AWTEvent.cFrom[n5] = null;
        }
        for (n5 = 0; n5 < n12; ++n5) {
            AWTEvent.cTo[n5] = null;
        }
        mouseEvent.source = object;
        mouseEvent.id = n8;
        ((AWTEvent)mouseEvent).setXY(n9, n10);
    }

    static void unregisterSource(Component component, Ptr ptr) {
        int n = Toolkit.evtUnregisterSource(ptr);
        AWTEvent.sources[n] = null;
        if (--nSources == 0 && Defaults.AutoStop) {
            System.getSecurityManager().checkExit(0);
            Toolkit.terminate();
            System.exit(0);
        }
    }

    protected static void updateToplevelBounds(Component component, int n, int n2, int n3, int n4) {
        component.x = n;
        component.y = n2;
        if (n3 != component.width || n4 != component.height) {
            component.width = n3;
            component.height = n4;
            if (component.isVisible) {
                component.isVisible = false;
                component.doLayout();
                component.isVisible = true;
            } else {
                component.doLayout();
            }
        }
    }

    static {
        mousePos = new Point();
        cFrom = new Component[10];
        cTo = new Component[10];
        evtLock = new Object();
        clickInterval = Defaults.ClickInterval;
        focusEvtCache = new FocusEvent(Window.dummy, 0);
        wndEvtCache = new WindowEvent(Window.dummy, 0);
        keyEvtCache = new KeyEvent(Window.dummy, 0, 0L, 0, 0);
        mouseEvtCache = new MouseEvent(Window.dummy, 0, 0L, 0, 0, 0, 0, false);
        paintEvtCache = new PaintEvent(Window.dummy, 0, new Rectangle());
        cmpEvtCache = new ComponentEvent(Window.dummy, 0);
        actEvtCache = new ActionEvent(Window.dummy, 0, null);
        itmEvtCache = new ItemEvent(null, 0, null, 0);
        adjEvtCache = new AdjustmentEvent(null, 0, 0, 0);
        sources = Toolkit.evtInit();
    }
}

