/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;

public class ZipInputStream
extends InflaterInputStream
implements ZipConstants {
    private byte[] zheader = new byte[30];
    private InflaterInputStream inflater;

    public ZipInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public ZipEntry getNextEntry() throws IOException {
        ZipInputStream zipInputStream = this;
        synchronized (zipInputStream) {
            ZipEntry zipEntry;
            try {
                super.read(this.zheader);
                long l = this.get32(0);
                if (l != 67324752L) {
                    if (l == 33639248L) {
                        ZipEntry zipEntry2 = null;
                        Object var11_5 = null;
                        return zipEntry2;
                    }
                    throw new IOException("LOC header signature bad");
                }
                char[] cArray = new char[this.get16(26)];
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = (char)super.read();
                }
                byte[] byArray = new byte[this.get16(28)];
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = (byte)super.read();
                }
                ZipEntry zipEntry3 = new ZipEntry(new String(cArray));
                zipEntry3.time = 0L;
                zipEntry3.crc = this.get32(14);
                zipEntry3.size = (int)this.get32(22);
                zipEntry3.method = this.get16(8);
                zipEntry3.extra = byArray;
                zipEntry3.comment = "";
                zipEntry3.flag = (int)this.get32(6);
                zipEntry3.version = this.get16(4);
                zipEntry3.csize = (int)this.get32(18);
                zipEntry3.offset = 0L;
                this.inflater = new InflaterInputStream(this.in);
                zipEntry = zipEntry3;
            }
            catch (Throwable throwable) {
                Object var11_7 = null;
                throw throwable;
            }
            Object var11_6 = null;
            return zipEntry;
        }
    }

    public void closeEntry() throws IOException {
        if (this.inflater != null) {
            this.inflater.close();
            this.inflater = null;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        ZipInputStream zipInputStream = this;
        synchronized (zipInputStream) {
            try {
                int n3 = this.inflater.read(byArray, n, n2);
                Object var7_6 = null;
                return n3;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                throw throwable;
            }
        }
    }

    public long skip(long l) throws IOException {
        ZipInputStream zipInputStream = this;
        synchronized (zipInputStream) {
            try {
                long l2 = this.inflater.skip(l);
                Object var7_4 = null;
                return l2;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                throw throwable;
            }
        }
    }

    public void close() throws IOException {
        this.closeEntry();
        super.close();
    }

    private int get16(int n) {
        int n2 = this.zheader[n + 0] << 0 | this.zheader[n + 1] << 8;
        return n2;
    }

    private long get32(int n) {
        long l = (long)this.zheader[n + 0] << 0 | (long)this.zheader[n + 1] << 8 | (long)this.zheader[n + 2] << 16 | (long)this.zheader[n + 3] << 24;
        return l;
    }
}

