/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class GZIPInputStream
extends InflaterInputStream {
    public static final int GZIP_MAGIC = 35615;
    protected CRC32 crc = new CRC32();
    protected boolean eos = false;

    public GZIPInputStream(InputStream inputStream) throws IOException {
        this(inputStream, 512);
    }

    public GZIPInputStream(InputStream inputStream, int n) throws IOException {
        super(inputStream, new Inflater(), n);
    }

    public void close() throws IOException {
        super.close();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.crc.update(byArray, n, n3);
        } else if (n3 == -1) {
            this.eos = true;
        }
        return n3;
    }
}

