/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Long
extends Number {
    private long value;
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class TYPE = Class.getPrimitiveClass("long");

    public Long(String string) throws NumberFormatException {
        this(Long.valueOf(string).intValue());
    }

    public Long(long l) {
        this.value = l;
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Long) {
            return this.longValue() == ((Long)object).longValue();
        }
        return false;
    }

    public float floatValue() {
        return this.value;
    }

    public static Long getLong(String string) {
        return Long.getLong(string, null);
    }

    public static Long getLong(String string, Long l) {
        int n;
        String string2;
        String string3 = l == null ? null : l.toString();
        String string4 = System.getProperty(string, string3);
        if (string4 == null) {
            return l;
        }
        if (string4.startsWith("0x-")) {
            return l;
        }
        if (string4.startsWith("#-")) {
            return l;
        }
        if (string4.endsWith("l") || string4.endsWith("L")) {
            return l;
        }
        if (string4.startsWith("0x")) {
            string2 = string4.substring(2);
            n = 16;
        } else if (string4.startsWith("#")) {
            string2 = string4.substring(1);
            n = 16;
        } else if (string4.startsWith("0")) {
            string2 = string4.substring(1);
            n = 8;
        } else {
            string2 = string4;
            n = 10;
        }
        if (string2.length() == 0) {
            return l;
        }
        try {
            return Long.valueOf(string2, n);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public static Long getLong(String string, long l) {
        return Long.getLong(string, new Long(l));
    }

    public int hashCode() {
        return this.intValue();
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public static long parseLong(String string) throws NumberFormatException {
        return Long.parseLong(string, 10);
    }

    public static long parseLong(String string, int n) {
        if (string.length() <= 0) {
            throw new NumberFormatException();
        }
        if (string.charAt(0) == '-') {
            return Long.parseLong(string.substring(1)) * -1L;
        }
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            int n2 = Character.digit(string.charAt(i), n);
            if (n2 == -1) {
                throw new NumberFormatException();
            }
            l = l * (long)n + (long)n2;
        }
        return l;
    }

    public static String toBinaryString(long l) {
        return Long.toString(l, 2);
    }

    public static String toHexString(long l) {
        return Long.toString(l, 16);
    }

    public static String toOctalString(long l) {
        return Long.toString(l, 8);
    }

    public String toString() {
        return Long.toString(this);
    }

    public static String toString(long l) {
        return Long.toString(l, 10);
    }

    public static String toString(long l, int n) {
        if (l == 0L) {
            return "0";
        }
        if (n < 2 || n > 36) {
            n = 10;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 1;
        if (l < 0L) {
            n2 = -1;
        }
        while (l != 0L) {
            char c = Character.forDigit(Math.abs((int)(l % (long)n)), n);
            l /= (long)n;
            stringBuffer.append(c);
        }
        if (n2 == -1) {
            stringBuffer.append('-');
        }
        stringBuffer.reverse();
        return stringBuffer.toString();
    }

    public static Long valueOf(String string) throws NumberFormatException {
        return Long.valueOf(string, 10);
    }

    public static Long valueOf(String string, int n) throws NumberFormatException {
        return new Long(Long.parseLong(string, n));
    }
}

