/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import java.util.Vector;

public class MemoryImageSource
implements ImageProducer {
    Vector consumers = new Vector(3);
    Hashtable props;
    int width;
    int height;
    int scan;
    int offset;
    int[] ipels;
    byte[] bpels;
    ColorModel model;
    boolean animated;
    boolean fullbuffers;

    public MemoryImageSource(int n, int n2, ColorModel colorModel, byte[] byArray, int n3, int n4) {
        this(n, n2, colorModel, byArray, n3, n4, (Hashtable)null);
    }

    public MemoryImageSource(int n, int n2, ColorModel colorModel, byte[] byArray, int n3, int n4, Hashtable hashtable) {
        this.width = n;
        this.height = n2;
        this.bpels = byArray;
        this.model = colorModel;
        this.offset = n3;
        this.scan = n4;
        this.props = hashtable;
    }

    public MemoryImageSource(int n, int n2, ColorModel colorModel, int[] nArray, int n3, int n4) {
        this(n, n2, colorModel, nArray, n3, n4, null);
    }

    public MemoryImageSource(int n, int n2, ColorModel colorModel, int[] nArray, int n3, int n4, Hashtable hashtable) {
        this.width = n;
        this.height = n2;
        this.ipels = nArray;
        this.model = colorModel;
        this.offset = n3;
        this.scan = n4;
        this.props = hashtable;
    }

    public MemoryImageSource(int n, int n2, int[] nArray, int n3, int n4) {
        this(n, n2, ColorModel.getRGBdefault(), nArray, n3, n4, null);
    }

    public MemoryImageSource(int n, int n2, int[] nArray, int n3, int n4, Hashtable hashtable) {
        this(n, n2, ColorModel.getRGBdefault(), nArray, n3, n4, hashtable);
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        if (!this.consumers.contains(imageConsumer)) {
            this.consumers.addElement(imageConsumer);
        }
    }

    protected void initializeConsumer(ImageConsumer imageConsumer) {
        if (this.isConsumer(imageConsumer)) {
            imageConsumer.setDimensions(this.width, this.height);
        }
        if (this.isConsumer(imageConsumer)) {
            imageConsumer.setColorModel(this.model);
        }
        if (this.isConsumer(imageConsumer)) {
            imageConsumer.setProperties(this.props);
        }
        if (this.isConsumer(imageConsumer)) {
            imageConsumer.setHints(30);
        }
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.consumers.contains(imageConsumer);
    }

    public void newPixels() {
        this.newPixels(0, 0, this.width, this.height, true);
    }

    public void newPixels(byte[] byArray, ColorModel colorModel, int n, int n2) {
        this.ipels = null;
        this.bpels = byArray;
        this.model = colorModel;
        this.offset = n;
        this.scan = n2;
        this.newPixels();
    }

    public void newPixels(int n, int n2, int n3, int n4) {
        this.newPixels(n, n2, n3, n4, true);
    }

    public void newPixels(int n, int n2, int n3, int n4, boolean bl) {
        if (!this.animated) {
            return;
        }
        if (this.fullbuffers) {
            n = 0;
            n2 = 0;
            n3 = this.width;
            n4 = this.height;
        }
        for (int i = 0; i < this.consumers.size(); ++i) {
            ImageConsumer imageConsumer = (ImageConsumer)this.consumers.elementAt(i);
            this.transferPels(imageConsumer, n, n2, n3, n4);
            if (!bl || !this.isConsumer(imageConsumer)) continue;
            imageConsumer.setHints(2);
        }
    }

    public void newPixels(int[] nArray, ColorModel colorModel, int n, int n2) {
        this.bpels = null;
        this.ipels = nArray;
        this.model = colorModel;
        this.offset = n;
        this.scan = n2;
        this.newPixels();
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.consumers.removeElement(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public void setAnimated(boolean bl) {
        this.animated = bl;
        if (!bl) {
            for (int i = 0; i < this.consumers.size(); ++i) {
                ImageConsumer imageConsumer = (ImageConsumer)this.consumers.elementAt(i);
                imageConsumer.imageComplete(3);
            }
            this.consumers.removeAllElements();
        }
    }

    public void setFullBufferUpdates(boolean bl) {
        this.fullbuffers = bl;
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
        this.initializeConsumer(imageConsumer);
        this.transferPels(imageConsumer, 0, 0, this.width, this.height);
        this.terminateConsumer(imageConsumer);
    }

    protected void terminateConsumer(ImageConsumer imageConsumer) {
        if (this.isConsumer(imageConsumer)) {
            imageConsumer.imageComplete(3);
            this.consumers.removeElement(imageConsumer);
        }
    }

    protected void transferPels(ImageConsumer imageConsumer, int n, int n2, int n3, int n4) {
        if (this.isConsumer(imageConsumer)) {
            int n5 = this.offset + n + this.scan * n2;
            if (this.bpels != null) {
                imageConsumer.setPixels(n, n2, n3, n4, this.model, this.bpels, n5, this.scan);
            } else if (this.ipels != null) {
                imageConsumer.setPixels(n, n2, n3, n4, this.model, this.ipels, n5, this.scan);
            }
        }
    }
}

