/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.ImageObserver;
import kaffe.util.Ptr;

public class Graphics {
    Ptr nativeData;
    int xOffset;
    int yOffset;
    Font fnt;
    Color fg;
    Color bg;
    Color xClr;
    Rectangle clip = new Rectangle();
    Graphics next;
    static Graphics cache;
    static Object lock;

    protected Graphics() {
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        Toolkit.graClearRect(this.nativeData, n, n2, n3, n4);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        int n5 = n > this.clip.x ? n : this.clip.x;
        int n6 = n2 > this.clip.y ? n2 : this.clip.y;
        int n7 = this.clip.x + this.clip.width;
        int n8 = this.clip.y + this.clip.height;
        int n9 = n + n3;
        int n10 = n2 + n4;
        int n11 = (n9 > n7 ? n7 : n9) - n5;
        int n12 = (n10 > n8 ? n8 : n10) - n6;
        if (n11 < 0) {
            n11 = 0;
        }
        if (n12 < 0) {
            n6 = 0;
        }
        this.clip.x = n5;
        this.clip.y = n6;
        this.clip.width = n11;
        this.clip.height = n12;
        Toolkit.graSetClip(this.nativeData, this.clip.x, this.clip.y, this.clip.width, this.clip.height);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        Toolkit.graCopyArea(this.nativeData, n, n2, n3, n4, n5, n6);
    }

    public Graphics create() {
        Graphics graphics = Graphics.getGraphics(this, this.xOffset, this.yOffset, this.clip.x, this.clip.y, this.clip.width, this.clip.height, this.fg, this.bg, this.fnt, false);
        if (this.xClr != null) {
            graphics.setXORMode(this.xClr);
        }
        return graphics;
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        Graphics graphics = Graphics.getGraphics(this, n + this.xOffset, n2 + this.yOffset, 0, 0, n3, n4, this.fg, this.bg, this.fnt, false);
        if (this.xClr != null) {
            graphics.setXORMode(this.xClr);
        }
        return graphics;
    }

    public void dispose() {
        if (this.bg == null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            try {
                this.xClr = null;
                this.fnt = null;
                this.fg = null;
                this.bg = null;
                this.next = cache;
                cache = this;
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Toolkit.graDraw3DRect(this.nativeData, n, n2, n3, n4, bl, this.fg.rgbValue);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Toolkit.graDrawArc(this.nativeData, n, n2, n3, n4, n5, n6);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        Toolkit.graDrawBytes(this.nativeData, byArray, n, n2, n3, n4);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        Toolkit.graDrawChars(this.nativeData, cArray, n, n2, n3, n4);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.width, image.height, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.width, image.height, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if ((Image.checkImage(image, -1, -1, imageObserver, true) & 0x20) != 0) {
            this.drawImg(image, n, n2, 0, 0, n3, n4, color);
            return true;
        }
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if ((Image.checkImage(image, -1, -1, imageObserver, true) & 0x20) != 0) {
            this.drawImgScaled(image, n, n2, n3, n4, n5, n6, n7, n8, color);
            return true;
        }
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    void drawImg(Image image, int n, int n2, int n3, int n4, int n5, int n6, Color color) {
        if (image.nativeData != null) {
            Toolkit.graDrawImage(this.nativeData, image.nativeData, n3, n4, n, n2, n5, n6, color == null ? -1 : color.nativeValue);
        }
    }

    void drawImgScaled(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
        if (image.nativeData != null) {
            Toolkit.graDrawImageScaled(this.nativeData, image.nativeData, n, n2, n3, n4, n5, n6, n7, n8, color == null ? -1 : color.nativeValue);
        }
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        Toolkit.graDrawLine(this.nativeData, n, n2, n3, n4);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        Toolkit.graDrawOval(this.nativeData, n, n2, n3, n4);
    }

    public void drawPolygon(Polygon polygon) {
        Toolkit.graDrawPolygon(this.nativeData, polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        Toolkit.graDrawPolygon(this.nativeData, nArray, nArray2, n);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        Toolkit.graDrawPolyline(this.nativeData, nArray, nArray2, n);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        Toolkit.graDrawRect(this.nativeData, n, n2, n3, n4);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        Toolkit.graDrawRoundRect(this.nativeData, n, n2, n3, n4, n5, n6);
    }

    public void drawString(String string, int n, int n2) {
        Toolkit.graDrawString(this.nativeData, string, n, n2);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Toolkit.graFill3DRect(this.nativeData, n, n2, n3, n4, bl, this.fg.rgbValue);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Toolkit.graFillArc(this.nativeData, n, n2, n3, n4, n5, n6);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        Toolkit.graFillOval(this.nativeData, n, n2, n3, n4);
    }

    public void fillPolygon(Polygon polygon) {
        Toolkit.graFillPolygon(this.nativeData, polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        Toolkit.graFillPolygon(this.nativeData, nArray, nArray2, n);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        Toolkit.graFillRect(this.nativeData, n, n2, n3, n4);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        Toolkit.graFillRoundRect(this.nativeData, n, n2, n3, n4, n5, n6);
    }

    protected void finalize() {
        if (this.nativeData != null) {
            Toolkit.graFreeGraphics(this.nativeData);
            this.nativeData = null;
        }
    }

    public Shape getClip() {
        return this.clip;
    }

    public Rectangle getClipBounds() {
        return this.clip;
    }

    static Graphics getClippedGraphics(Component component, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = 0;
        int n6 = 0;
        Color color = component.fgClr;
        Color color2 = component.bgClr;
        Font font = component.font;
        if (component.width == 0 || component.height == 0) {
            return null;
        }
        while (component.isVisible) {
            int n7;
            if (component.parent == null) {
                return Graphics.getGraphics(component, n5, n6, n, n2, n3, n4, color, color2, font, bl);
            }
            n5 += component.x;
            n6 += component.y;
            Container container = component.parent;
            int n8 = 0;
            int n9 = 0;
            int n10 = container.width;
            int n11 = container.height;
            if (container.insets != Insets.noInsets) {
                Insets insets = container.insets;
                n8 += insets.left;
                n9 += insets.top;
                n10 -= insets.right;
                n11 -= insets.bottom;
            }
            if (n5 + n < n8) {
                int n12 = n8 - n5;
                n3 -= n12 - n;
                n = n12;
            }
            if (n6 + n2 < n9) {
                int n13 = n9 - n6;
                n4 -= n13 - n2;
                n2 = n13;
            }
            int n14 = n + n3;
            int n15 = n2 + n4;
            int n16 = n5 + n14;
            if (n16 > n10) {
                n3 -= n16 - n10;
            }
            if ((n7 = n6 + n15) > n11) {
                n4 -= n7 - n11;
            }
            component = container;
            if (color == null) {
                color = component.fgClr;
            }
            if (color2 == null) {
                color2 = component.bgClr;
            }
            if (font != null) continue;
            font = component.font;
        }
        return null;
    }

    public Color getColor() {
        return this.fg;
    }

    public Font getFont() {
        return this.fnt;
    }

    public FontMetrics getFontMetrics() {
        return FontMetrics.getFontMetrics(this.fnt);
    }

    public FontMetrics getFontMetrics(Font font) {
        return FontMetrics.getFontMetrics(font);
    }

    static Graphics getGraphics(Object object, int n, int n2, int n3, int n4, int n5, int n6, Color color, Color color2, Font font, boolean bl) {
        Graphics graphics;
        Ptr ptr = null;
        int n7 = 0;
        if (object instanceof Window) {
            ptr = ((Window)object).nativeData;
            n7 = 0;
        } else if (object instanceof Image) {
            ptr = ((Image)object).nativeData;
            n7 = 1;
        } else if (object instanceof Graphics) {
            ptr = ((Graphics)object).nativeData;
            n7 = 2;
        }
        if (ptr == null) {
            return null;
        }
        Object object2 = lock;
        synchronized (object2) {
            try {
                if (cache == null) {
                    graphics = new Graphics();
                } else {
                    graphics = cache;
                    cache = graphics.next;
                    graphics.next = null;
                }
                Object var16_15 = null;
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                throw throwable;
            }
        }
        graphics.xOffset = n;
        graphics.yOffset = n2;
        graphics.clip.x = n3;
        graphics.clip.y = n4;
        graphics.clip.width = n5;
        graphics.clip.height = n6;
        graphics.fnt = font;
        graphics.fg = color;
        graphics.bg = color2;
        graphics.nativeData = Toolkit.graInitGraphics(graphics.nativeData, ptr, n7, n, n2, n3, n4, n5, n6, font.nativeData, color.nativeValue, color2.nativeValue, bl);
        return graphics;
    }

    void setBackColor(Color color) {
        if (color != null && color != this.bg) {
            this.bg = color;
            Toolkit.graSetBackColor(this.nativeData, this.bg.nativeValue);
        }
    }

    public void setClip(Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.clip.x = n;
        this.clip.y = n2;
        this.clip.width = n3;
        this.clip.height = n4;
        Toolkit.graSetClip(this.nativeData, n, n2, n3, n4);
    }

    public void setColor(Color color) {
        if (color != null && color != this.fg) {
            this.fg = color;
            Toolkit.graSetColor(this.nativeData, this.fg.nativeValue);
        }
    }

    public void setFont(Font font) {
        if (font != null && font != this.fnt) {
            this.fnt = font;
            Toolkit.graSetFont(this.nativeData, this.fnt.nativeData);
        }
    }

    void setGraphics(Ptr ptr, int n, int n2, int n3, int n4, int n5, int n6, int n7, Color color, Color color2, Font font, boolean bl) {
        this.xOffset = n2;
        this.yOffset = n3;
        this.clip.x = n4;
        this.clip.y = n5;
        this.clip.width = n6;
        this.clip.height = n7;
        if (font != null) {
            this.fnt = font;
        }
        if (color != null) {
            this.fg = color;
        }
        if (color2 != null) {
            this.bg = color2;
        }
        this.nativeData = Toolkit.graInitGraphics(this.nativeData, ptr, n, n2, n3, n4, n5, n6, n7, this.fnt.nativeData, this.fg.nativeValue, this.bg.nativeValue, bl);
    }

    public void setPaintMode() {
        if (this.xClr != null) {
            this.xClr = null;
            Toolkit.graSetPaintMode(this.nativeData);
        }
    }

    public void setXORMode(Color color) {
        if (color != this.xClr) {
            this.xClr = color;
            Toolkit.graSetXORMode(this.nativeData, this.xClr.nativeValue);
        }
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.getClass().getName()).concat(String.valueOf(" ["))).concat(String.valueOf(this.xOffset))).concat(String.valueOf(','))).concat(String.valueOf(this.yOffset))).concat(String.valueOf(", "))).concat(String.valueOf(this.clip))).concat(String.valueOf(']'));
    }

    public void translate(int n, int n2) {
        this.xOffset += n;
        this.yOffset += n2;
        Toolkit.graSetOffset(this.nativeData, this.xOffset, this.yOffset);
    }

    void wrapChildPaint(Component component, int n, int n2, int n3, int n4, int n5, int n6, Color color, Color color2, Font font, boolean bl) {
        Color color3 = this.fg;
        Color color4 = this.bg;
        Font font2 = this.fnt;
        int n7 = this.clip.x;
        int n8 = this.clip.y;
        int n9 = this.clip.width;
        int n10 = this.clip.height;
        this.xOffset += n;
        this.yOffset += n2;
        this.clip.x = n3;
        this.clip.y = n4;
        this.clip.width = n5;
        this.clip.height = n6;
        if (font != null) {
            this.fnt = font;
        }
        if (color != null) {
            this.fg = color;
        }
        if (color2 != null) {
            this.bg = color2;
        }
        Toolkit.graInitGraphics(this.nativeData, null, 0, this.xOffset, this.yOffset, this.clip.x, this.clip.y, this.clip.width, this.clip.height, this.fnt.nativeData, this.fg.nativeValue, this.bg.nativeValue, bl);
        component.paint(this);
        this.xOffset -= n;
        this.yOffset -= n2;
        this.clip.x = n7;
        this.clip.y = n8;
        this.clip.width = n9;
        this.clip.height = n10;
        this.fnt = font2;
        this.fg = color3;
        this.bg = color4;
        Toolkit.graInitGraphics(this.nativeData, null, 0, this.xOffset, this.yOffset, this.clip.x, this.clip.y, this.clip.width, this.clip.height, this.fnt.nativeData, this.fg.nativeValue, this.bg.nativeValue, false);
    }

    static {
        lock = new Object();
    }
}

