/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Defaults;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class CheckboxMenuItem
extends MenuItem
implements ItemSelectable {
    boolean isChecked;
    ItemListener iListener;

    public CheckboxMenuItem() {
        this("", false);
    }

    public CheckboxMenuItem(String string) {
        this(string, false);
    }

    public CheckboxMenuItem(String string, boolean bl) {
        super(string);
        this.isChecked = bl;
    }

    public void addItemListener(ItemListener itemListener) {
        this.iListener = AWTEventMulticaster.add(this.iListener, itemListener);
    }

    public Object[] getSelectedObjects() {
        if (this.isChecked) {
            Object[] objectArray = new Object[]{this.getLabel()};
            return objectArray;
        }
        return null;
    }

    public boolean getState() {
        return this.isChecked;
    }

    int getWidth() {
        int n = super.getWidth();
        return n += 3 * this.getHeight() / 4;
    }

    int paint(Graphics graphics, int n, int n2, int n3, Color color, Color color2, boolean bl) {
        int n4 = this.getHeight();
        graphics.setColor(this.isChecked ? Defaults.FocusClr : Defaults.BtnClr);
        graphics.fill3DRect(n, n2 + n4 / 4, n4 / 2, n4 / 2, !this.isChecked);
        return super.paint(graphics, n += 3 * n4 / 4, n2, n3, color, color2, bl);
    }

    public String paramString() {
        return String.valueOf(String.valueOf(super.paramString()).concat(String.valueOf(", "))).concat(String.valueOf(this.isChecked ? "checked" : "unchecked"));
    }

    void process() {
        this.setState(!this.isChecked);
        if (this.hasToNotify(this.iListener)) {
            ItemEvent itemEvent = AWTEvent.getItemEvent(this, 701);
            ((AWTEvent)itemEvent).setItemEvent(this.getLabel(), this.isChecked ? 1 : 2);
            Toolkit.eventQueue.postEvent(itemEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.hasToNotify(this.iListener)) {
            this.iListener.itemStateChanged(itemEvent);
        }
    }

    public void removeItemListener(ItemListener itemListener) {
        this.iListener = AWTEventMulticaster.remove(this.iListener, itemListener);
    }

    public synchronized void setState(boolean bl) {
        this.isChecked = bl;
    }
}

