/*
 * Decompiled with CFR 0.152.
 */
package pizza.compiler;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import pizza.compiler.Main;
import pizza.compiler.Win32;

public class Express {
    static Main compiler;
    static PrintStream out;
    static final int filesMax = 1000;
    static String[] files;
    static int fileCount;

    static String getFileName(String string) {
        Express.printFileList();
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(0) >= '0' && string.charAt(0) <= '9') {
            try {
                int n = new Integer(string);
                return files[n];
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        for (int i = 0; i < fileCount; ++i) {
            if (!files[i].equals(string)) continue;
            return string;
        }
        if (fileCount < 1000) {
            Express.files[Express.fileCount++] = string;
            System.out.println(String.valueOf(String.valueOf(fileCount - 1).concat(String.valueOf(": "))).concat(String.valueOf(files[fileCount - 1])));
        }
        return string;
    }

    static void deleteFileName(String string) {
        try {
            int n = new Integer(string);
            Express.files[n] = "";
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    static void printFileList() {
        for (int i = 0; i < fileCount; ++i) {
            System.out.println(String.valueOf(String.valueOf(i).concat(String.valueOf(": "))).concat(String.valueOf(files[i])));
        }
    }

    static int option(String[] stringArray, int n) {
        String string = stringArray[n];
        stringArray[n] = null;
        if (string.equals("-classpath") && n + 1 < stringArray.length) {
            Main.setClassPath(stringArray[n + 1]);
            stringArray[++n] = null;
        } else if (string.equals("-d") && n + 1 < stringArray.length) {
            Main.setDestinationDir(stringArray[n + 1]);
            stringArray[++n] = null;
        } else if (string.equals("-version")) {
            System.out.println("Version 0.2, Written by Enno Runne");
            System.out.println("Copyright (c) 1997 Martin Odersky.");
            System.out.println("further information at http://www.cis.unisa.edu.au/~pizza/");
        } else if (!Main.argument(string)) {
            System.out.println(String.valueOf("unrecognized option: ").concat(String.valueOf(string)));
        }
        return n + 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] stringArray) throws Throwable {
        String string;
        out.println(String.valueOf(String.valueOf("Pizza Express (using Version ").concat(String.valueOf(Main.version()))).concat(String.valueOf(")")));
        if (stringArray.length == 0) {
            Express.help();
        }
        compiler = new Main();
        Main.init();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("-")) {
                n = Express.option(stringArray, n);
                continue;
            }
            if (fileCount >= 1000) continue;
            Express.files[Express.fileCount++] = stringArray[n++];
        }
        Express.printFileList();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        Main.argument("-pizza");
        do {
            out.print("? ");
            string = bufferedReader.readLine();
            if (string == null) return;
            if (string.startsWith("?") || fileCount == 0 && string.length() == 0) {
                out.println("  ?           this help");
                out.println("  :q          quit Pizza Express");
                out.println("  :p [param]  set a command line parameter");
                out.println("  :d [num]    delete filename num");
                out.println("  [file]      compile file (wildcards allowed)");
                out.println("  [num]       compile file with number num");
                continue;
            }
            if (!string.startsWith(":")) {
                String[] stringArray2 = new String[]{Express.getFileName(string)};
                if (stringArray2[0] == null) continue;
                out.println(String.valueOf("   source: ").concat(String.valueOf(stringArray2[0])));
                out.println("----------------------compiling---------");
                Main.compile(Win32.expand(stringArray2));
                out.println("----------------------------------------");
                continue;
            }
            if (string.startsWith(":d ")) {
                Express.deleteFileName(string.substring(3, string.length()));
                continue;
            }
            if (!string.startsWith(":p ") || Main.argument(string.substring(3, string.length()))) continue;
            out.println("option not recognized!");
        } while (!string.startsWith(":q"));
        return;
    }

    static void help() {
        System.out.println("Usage: pizzaexpress [ options ] file[s]\n");
        System.out.println("where options include:");
        System.out.println("  -classpath pathname     use given classpath");
        System.out.println("  -d filename             redirect classfile output");
        System.out.println("  -experimental           enable experimental features");
        System.out.println("  -g                      include debug information");
        System.out.println("  -java                   accept only standard Java input");
        System.out.println("  -pizza                  accept standard Pizza input");
        System.out.println("  -printsearch            print information where classfiles are searched");
        System.out.println("  -prompt                 stop after each error");
        System.out.println("  -s                      emit java sources instead of classfiles");
        System.out.println("  -scramble               scramble private identifiers in bytecode");
        System.out.println("  -scrambleall            scramble package visible identifiers in bytecode");
        System.out.println("  -switchcheck            warn about fall-through in switches");
        System.out.println("  -verbose                print detailed log");
        System.out.println("  -version                print version information");
        System.out.println();
    }

    static {
        out = System.out;
        files = new String[1000];
        fileCount = 0;
    }
}

