/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Vector;

public final class BitSet
implements Cloneable {
    Vector bits = new Vector();
    static final int roundBits = 64;

    public BitSet() {
        this(64);
    }

    public BitSet(int n) {
        n = n + 64 - 1 & 0xFFFFFFC0;
        this.ensureSize(n);
    }

    public void and(BitSet bitSet) {
        int n = Math.min(this.size(), bitSet.size());
        for (int i = 0; i < n; ++i) {
            if (!this.get(i) || bitSet.get(i)) continue;
            this.clear(i);
        }
    }

    public void clear(int n) {
        this.ensureSize(n + 1);
        this.bits.setElementAt(new Boolean(false), n);
    }

    public Object clone() {
        BitSet bitSet = new BitSet(this.size());
        int n = bitSet.size();
        for (int i = 0; i < n; ++i) {
            if (!this.get(i)) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    private void ensureSize(int n) {
        int n2 = this.bits.size();
        if (n > n2) {
            this.bits.setSize(n);
            while (n2 < n) {
                this.bits.setElementAt(new Boolean(false), n2);
                ++n2;
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof BitSet) {
            BitSet bitSet = (BitSet)object;
            if (this.size() != bitSet.size()) {
                return false;
            }
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                if (this.get(i) == bitSet.get(i)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean get(int n) {
        this.ensureSize(n + 1);
        return (Boolean)this.bits.elementAt(n);
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < Math.min(32, this.size()); ++i) {
            n *= 2;
            if (!this.get(i)) continue;
            ++n;
        }
        return n;
    }

    public void or(BitSet bitSet) {
        int n = Math.min(this.size(), bitSet.size());
        for (int i = 0; i < n; ++i) {
            if (this.get(i) || !bitSet.get(i)) continue;
            this.set(i);
        }
    }

    public void set(int n) {
        this.ensureSize(n + 1);
        this.bits.setElementAt(new Boolean(true), n);
    }

    public int size() {
        return this.bits.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        stringBuffer.append('{');
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!this.get(i)) continue;
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(i);
            bl = false;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public void xor(BitSet bitSet) {
        int n = Math.min(this.size(), bitSet.size());
        for (int i = 0; i < n; ++i) {
            if (!this.get(i) && bitSet.get(i)) {
                this.set(i);
                continue;
            }
            if (!this.get(i) || !bitSet.get(i)) continue;
            this.clear(i);
        }
    }
}

