/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddressImpl;
import java.net.UnknownHostException;

public final class InetAddress {
    private String hostName;
    private int address;
    private int family;
    private static InetAddress localAddress;
    protected static InetAddress anyLocalAddress;
    private static InetAddressImpl impl;

    public InetAddress() {
    }

    private InetAddress(int n) {
        this.address = n;
        this.hostName = null;
        this.family = impl.getInetFamily();
    }

    private static int bytesToInt(byte[] byArray) {
        int n = (byArray[0] & 0xFF) << 24;
        int n2 = (byArray[1] & 0xFF) << 16;
        int n3 = (byArray[2] & 0xFF) << 8;
        int n4 = byArray[3] & 0xFF;
        int n5 = n | n2 | n3 | n4;
        return n5;
    }

    public boolean equals(Object object) {
        byte[] byArray;
        byte[] byArray2;
        if (object != null && object instanceof InetAddress && (byArray2 = ((InetAddress)object).getAddress()).length == (byArray = this.getAddress()).length) {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return false;
            }
            return this.getHostName().equals(((InetAddress)object).getHostName());
        }
        return false;
    }

    public byte[] getAddress() {
        if (this == localAddress) {
            return null;
        }
        return InetAddress.intToBytes(this.address);
    }

    public static synchronized InetAddress[] getAllByName(String string) throws UnknownHostException {
        if (string == null) {
            InetAddress[] inetAddressArray = new InetAddress[]{localAddress};
            return inetAddressArray;
        }
        byte[][] byArray = impl.lookupAllHostAddr(string);
        int n = byArray.length;
        InetAddress[] inetAddressArray = new InetAddress[n];
        for (int i = 0; i < n; ++i) {
            inetAddressArray[i] = new InetAddress(InetAddress.bytesToInt(byArray[i]));
        }
        return inetAddressArray;
    }

    public static synchronized InetAddress getByName(String string) throws UnknownHostException {
        if (string == null || string == "") {
            return localAddress;
        }
        InetAddress inetAddress = new InetAddress(InetAddress.bytesToInt(impl.lookupHostAddr(string)));
        return inetAddress;
    }

    public String getHostAddress() {
        if (this == localAddress) {
            return null;
        }
        byte[] byArray = InetAddress.intToBytes(this.address);
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(byArray[0] & 0xFF).concat(String.valueOf("."))).concat(String.valueOf(byArray[1] & 0xFF))).concat(String.valueOf("."))).concat(String.valueOf(byArray[2] & 0xFF))).concat(String.valueOf("."))).concat(String.valueOf(byArray[3] & 0xFF));
    }

    public String getHostName() {
        try {
            if (this.hostName == null) {
                this.hostName = impl.getHostByAddr(this.address);
            }
            return this.hostName;
        }
        catch (UnknownHostException unknownHostException) {
            return "<unknown>";
        }
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        String string = impl.getLocalHostName();
        try {
            System.getSecurityManager().checkConnect(string, -1);
        }
        catch (SecurityException securityException) {
            return localAddress;
        }
        return InetAddress.getByName(string);
    }

    public int hashCode() {
        return this.address;
    }

    private static byte[] intToBytes(int n) {
        byte[] byArray = new byte[]{(byte)((n & 0xFF000000) >> 24), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
        return byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHostName());
        stringBuffer.append("/");
        byte[] byArray = InetAddress.intToBytes(this.address);
        for (int i = 0; i < byArray.length - 1; ++i) {
            stringBuffer.append(String.valueOf(byArray[i] & 0xFF));
            stringBuffer.append(".");
        }
        stringBuffer.append(String.valueOf(byArray[byArray.length - 1] & 0xFF));
        return stringBuffer.toString();
    }

    static {
        System.loadLibrary("net");
        impl = new InetAddressImpl();
        byte[] byArray = new byte[]{127, 0, 0, 1};
        localAddress = new InetAddress(InetAddress.bytesToInt(byArray));
        anyLocalAddress = new InetAddress();
        impl.makeAnyLocalAddress(anyLocalAddress);
    }
}

