/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written;

    public DataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    private byte[] charToUTF(char c) {
        byte[] byArray = c >= '\u0001' && c <= '\u007f' ? new byte[]{(byte)c} : ((c >= '\u0080' && c <= '\u07ff') | c == '\u0000' ? new byte[]{(byte)((c & 0x7C0) >> 6 | 0xC0), (byte)(c & 0x3F | 0x80)} : new byte[]{(byte)((c & 0xF000) >> 12 | 0xE0), (byte)((c & 0xFC0) >> 6 | 0x80), (byte)(c & 0x3F | 0x80)});
        return byArray;
    }

    public void flush() throws IOException {
        super.flush();
    }

    public final int size() {
        return this.written;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.written += n2;
    }

    public synchronized void write(int n) throws IOException {
        super.write(n);
        ++this.written;
    }

    public final void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.writeByte(1);
        } else {
            this.writeByte(0);
        }
    }

    public final void writeByte(int n) throws IOException {
        super.write(n);
        ++this.written;
    }

    public final void writeBytes(String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            this.writeByte(string.charAt(i) & 0xFF);
        }
    }

    public final void writeChar(int n) throws IOException {
        this.writeByte((n & 0xFF00) >> 8);
        this.writeByte(n & 0xFF);
    }

    public final void writeChars(String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeInt(int n) throws IOException {
        int n2 = -16777216;
        for (int i = 3; i >= 0; --i) {
            this.writeByte((n & n2) >> i * 8);
            n2 >>= 8;
        }
    }

    public final void writeLong(long l) throws IOException {
        int n = (int)(l >> 32);
        int n2 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.writeInt(n);
        this.writeInt(n2);
    }

    public final void writeShort(int n) throws IOException {
        this.writeChar(n);
    }

    public final synchronized void writeUTF(String string) throws IOException {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n += this.charToUTF(string.charAt(i)).length;
        }
        this.writeShort(n);
        for (int i = 0; i < string.length(); ++i) {
            byte[] byArray = this.charToUTF(string.charAt(i));
            this.write(byArray, 0, byArray.length);
        }
    }
}

