/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.InputStream;

public class ByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos = 0;
    protected int count;
    protected int mark;
    private int off;

    public ByteArrayInputStream(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ByteArrayInputStream(byte[] byArray, int n, int n2) {
        this.count = n2;
        this.off = n;
        this.buf = byArray;
        this.mark = 0;
        this.pos = 0;
    }

    public synchronized int available() {
        return this.count - this.pos;
    }

    public void mark(int n) {
        this.mark = n;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized int read() {
        if (this.pos == this.count) {
            return -1;
        }
        return this.buf[this.off + this.pos++] & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        if (this.pos == this.count) {
            return -1;
        }
        int n3 = Math.min(this.available(), n2);
        System.arraycopy(this.buf, this.off + this.pos, byArray, n, n3);
        this.pos += n3;
        return n3;
    }

    public synchronized void reset() {
        this.pos = this.mark;
    }

    public synchronized long skip(long l) {
        long l2 = Math.min(l, (long)this.available());
        this.pos += (int)l2;
        return l2;
    }
}

