/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int markpos = -1;
    protected int marklimit;
    private boolean EOF = false;
    private static final int DEFAULTBUFFER = 2048;

    public BufferedInputStream(InputStream inputStream) {
        this(inputStream, 2048);
    }

    public BufferedInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.buf = new byte[n];
        this.count = n;
        this.pos = n;
        this.marklimit = 0;
    }

    public synchronized int available() throws IOException {
        return this.count - this.pos + this.in.available();
    }

    private void fill() {
        this.marklimit = 0;
        this.pos = 0;
        try {
            this.count = super.read(this.buf);
        }
        catch (IOException iOException) {
            this.count = -1;
        }
    }

    public synchronized void mark(int n) {
        this.marklimit = n;
        this.markpos = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized int read() throws IOException {
        if (this.pos >= this.count) {
            this.fill();
            if (this.count <= 0) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.count <= 0) {
            return -1;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            if (this.pos >= this.count) {
                if (n3 > 0 && this.count != this.buf.length) break;
                this.fill();
                if (this.count <= 0) break;
            }
            byArray[n + n3] = this.buf[this.pos++];
        }
        return n3;
    }

    public synchronized void reset() throws IOException {
        if (this.pos > this.markpos + this.marklimit) {
            throw new IOException();
        }
        this.pos = this.markpos;
    }

    public synchronized long skip(long l) throws IOException {
        long l2 = l - (long)(this.count - this.pos);
        if (l2 <= 0L) {
            this.pos += (int)l;
            return l;
        }
        l2 = super.skip(l2) + (long)(this.count - this.pos);
        this.pos = this.count;
        return l2;
    }
}

