/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Defaults;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.WMEvent;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import kaffe.util.Ptr;

public class Window
extends Container {
    Ptr nativeData;
    WindowListener wndListener;
    Frame owner;
    static Window dummy = new Window();

    Window() {
        this.isVisible = false;
        this.fgClr = Defaults.WndForeground;
        this.bgClr = Defaults.WndBackground;
        this.font = Defaults.WndFont;
    }

    public Window(Frame frame) {
        this();
        this.owner = frame;
    }

    public void addNotify() {
        if (this.nativeData == null) {
            if (Toolkit.isWrongThread()) {
                WMEvent wMEvent = new WMEvent(this, 1901);
                Toolkit.eventQueue.postEvent(wMEvent);
                while (this.nativeData == null) {
                    try {
                        wMEvent.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                if (this.owner != null && this.owner.nativeData == null) {
                    this.owner.addNotify();
                }
                if (this.width == 0 || this.height == 0) {
                    this.setSize(this.getPreferredSize());
                }
                if ((this.nativeData = this.createNativeWindow()) == null) {
                    throw new AWTError(String.valueOf("native create failed: ").concat(String.valueOf(this)));
                }
                AWTEvent.registerSource(this, this.nativeData);
                super.addNotify();
                if (this.hasToNotify(64, this.wndListener)) {
                    Toolkit.eventQueue.postEvent(new WindowEvent(this, 200));
                }
            }
        }
    }

    public void addWindowListener(WindowListener windowListener) {
        this.wndListener = AWTEventMulticaster.add(this.wndListener, windowListener);
        this.eventMask |= 0x40;
    }

    Ptr createNativeWindow() {
        return Toolkit.wndCreateWindow(this.owner != null ? this.owner.nativeData : null, this.x, this.y, this.width, this.height, this.cursor.type, this.bgClr.nativeValue);
    }

    public void dispose() {
        this.isVisible = false;
        if (this.nativeData != null) {
            if (AWTEvent.activeWindow == this) {
                AWTEvent.sendFocusEvent(AWTEvent.keyTgt, false, true);
            }
            Toolkit.wndDestroyWindow(this.nativeData);
        }
    }

    public void dispose_X() {
        if (this.nativeData != null && this.x != Integer.MIN_VALUE) {
            if (AWTEvent.activeWindow == this) {
                AWTEvent.sendFocusEvent(AWTEvent.keyTgt, false, true);
            }
            Toolkit.wndDestroyWindow(this.nativeData);
            this.x = Integer.MIN_VALUE;
        }
        this.isVisible = false;
    }

    LayoutManager getDefaultLayout() {
        return new BorderLayout();
    }

    public Container getParent() {
        return this.owner;
    }

    public void pack() {
        if (this.nativeData == null) {
            this.addNotify();
        }
        if (this.width == 0 || this.height == 0) {
            this.setSize(this.getPreferredSize());
        }
    }

    void processPaintEvent(PaintEvent paintEvent) {
        if (this.isVisible && this.width > 0) {
            Rectangle rectangle = paintEvent.getUpdateRect();
            Graphics graphics = Graphics.getGraphics(this, 0, 0, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.fgClr, this.bgClr, this.font, true);
            if (graphics != null) {
                this.paint(graphics);
                graphics.dispose();
            }
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (this.hasToNotify(64, this.wndListener)) {
            switch (windowEvent.getID()) {
                case 200: {
                    this.wndListener.windowOpened(windowEvent);
                    break;
                }
                case 201: {
                    this.wndListener.windowClosing(windowEvent);
                    break;
                }
                case 202: {
                    this.wndListener.windowClosed(windowEvent);
                    break;
                }
                case 203: {
                    this.wndListener.windowIconified(windowEvent);
                    break;
                }
                case 204: {
                    this.wndListener.windowDeiconified(windowEvent);
                    break;
                }
                case 205: {
                    this.wndListener.windowActivated(windowEvent);
                    break;
                }
                case 206: {
                    this.wndListener.windowDeactivated(windowEvent);
                }
            }
        }
    }

    public void removeNotify() {
        if (this.nativeData != null) {
            if (Toolkit.isWrongThread()) {
                WMEvent wMEvent = new WMEvent(this, 1902);
                Toolkit.eventQueue.postEvent(wMEvent);
                while (this.nativeData == null) {
                    try {
                        wMEvent.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                super.removeNotify();
                AWTEvent.unregisterSource(this, this.nativeData);
                this.nativeData = null;
            }
        }
    }

    public void removeWindowListener(WindowListener windowListener) {
        this.wndListener = AWTEventMulticaster.remove(this.wndListener, windowListener);
    }

    public void repaint(int n, int n2, int n3, int n4) {
        Graphics graphics;
        if (this.isVisible && n3 > 0 && (graphics = Graphics.getGraphics(this, 0, 0, n, n2, n3, n4, this.fgClr, this.bgClr, this.font, true)) != null) {
            this.update(graphics);
            graphics.dispose();
        }
    }

    public void requestFocus() {
        if (this.nativeData != null && this.isVisible) {
            Toolkit.wndRequestFocus(this.nativeData);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        if (this.nativeData != null) {
            Toolkit.wndSetWindowBounds(this.nativeData, n, n2, n3, n4);
        } else {
            this.doLayout();
        }
    }

    void setNativeCursor(Cursor cursor) {
        if (this.nativeData != null) {
            Toolkit.wndSetCursor(this.nativeData, cursor.type);
        }
    }

    public void setVisible(boolean bl) {
        if (this.nativeData == null) {
            this.addNotify();
        }
        super.setVisible(bl);
        if (bl) {
            Toolkit.eventThread.show(this);
        } else {
            Toolkit.wndSetVisible(this.nativeData, bl);
        }
    }

    public void show() {
        this.setVisible(true);
    }

    public void toBack() {
        if (this.nativeData != null) {
            Toolkit.wndToBack(this.nativeData);
        }
    }

    public void toFront() {
        if (this.nativeData != null) {
            Toolkit.wndToFront(this.nativeData);
        }
    }
}

