/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.RowCanvas;
import java.awt.Scrollbar;
import java.awt.TextBuffer;
import java.awt.TextComponent;
import java.awt.TextCursor;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class TextArea
extends TextComponent {
    public static final int SCROLLBARS_VERTICAL_ONLY = 1;
    public static final int SCROLLBARS_HORIZONTAL_ONLY = 2;
    public static final int SCROLLBARS_NONE = 0;
    public static final int SCROLLBARS_BOTH = 3;
    int tabWidth;
    int crows;
    int ccols;
    TextPane tp = new TextPane();

    public TextArea() {
        this(null, 10, 10, 3);
    }

    public TextArea(String string) {
        this(string, 10, 10, 3);
    }

    public TextArea(String string, int n, int n2) {
        this(string, n, n2, 3);
    }

    public TextArea(String string, int n, int n2, int n3) {
        this.crows = n;
        this.ccols = n2;
        this.setLayout(null);
        this.setFont(Defaults.TextAreaFont);
        if ((n3 & 1) > 0) {
            this.tp.vScroll = new Scrollbar(1);
            this.add(this.tp.vScroll);
        }
        if ((n3 & 2) > 0) {
            this.tp.hScroll = new Scrollbar(0);
            this.tp.hScroll.setValues(0, 5 * this.tabWidth, 0, 100 * this.tp.fm.charWidth('x'));
            this.tp.hScroll.setUnitIncrement(this.tp.fm.charWidth('x'));
            this.add(this.tp.hScroll);
        }
        this.add(this.tp);
        this.tp.setListeners();
        this.setBackground(Defaults.TextAreaBgClr);
        this.setForeground(Defaults.TextAreaTxtClr);
        if (string != null) {
            this.append(string);
        }
    }

    public TextArea(int n, int n2) {
    }

    public void add(PopupMenu popupMenu) {
        this.tp.add(popupMenu);
    }

    public synchronized void append(String string) {
        this.tp.append(string);
    }

    String[] breakLines(String string) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        if (string == null) {
            return new String[0];
        }
        char[] cArray = string.toCharArray();
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] != '\n') continue;
            ++n4;
        }
        String[] stringArray = new String[n4];
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] != '\n') continue;
            stringArray[n3++] = cArray[n - 1] == '\r' ? string.substring(n2, n - 1) : string.substring(n2, n);
            n2 = n + 1;
        }
        if (n2 < cArray.length) {
            stringArray[n3] = string.substring(n2, cArray.length);
        }
        return stringArray;
    }

    public void doLayout() {
        this.tp.innerLayout();
    }

    public int getCaretPosition() {
        Point point = new Point(this.tp.tCursor.index, this.tp.tCursor.yindex);
        return this.tp.get1D(point);
    }

    public int getColumns() {
        return this.ccols;
    }

    public Dimension getMinimumSize() {
        return this.getMinimumSize(this.crows, this.ccols);
    }

    public Dimension getMinimumSize(int n, int n2) {
        return new Dimension(n2 * this.tp.fm.charWidth('x'), n * this.tp.fm.getHeight());
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.crows, this.ccols);
    }

    public Dimension getPreferredSize(int n, int n2) {
        return new Dimension(n2 * this.tp.fm.charWidth('x'), n * this.tp.fm.getHeight());
    }

    public int getRows() {
        return this.crows;
    }

    public int getScrollbarVisibility() {
        if (this.tp.hScroll == null && this.tp.vScroll == null) {
            return 0;
        }
        if (this.tp.hScroll == null) {
            return 1;
        }
        if (this.tp.vScroll == null) {
            return 2;
        }
        return 3;
    }

    public String getSelectedText() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = Math.min(this.tp.sSel.y, this.tp.eSel.y);
        int n2 = Math.max(this.tp.sSel.y, this.tp.eSel.y);
        for (int i = n; i <= n2; ++i) {
            TextBuffer textBuffer = (TextBuffer)this.tp.rows.elementAt(i);
            int n3 = this.tp.selXStart(i);
            int n4 = this.tp.selXEnd(i, textBuffer);
            stringBuffer.append(textBuffer.buf, n3, n4 - n3);
            if (i >= n2) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public int getSelectionEnd() {
        int n = this.tp.get1D(this.tp.sSel);
        int n2 = this.tp.get1D(this.tp.eSel);
        return Math.max(n, n2);
    }

    public int getSelectionStart() {
        int n = this.tp.get1D(this.tp.sSel);
        int n2 = this.tp.get1D(this.tp.eSel);
        return Math.min(n, n2);
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.tp.rows.size();
        for (int i = 0; i < n; ++i) {
            TextBuffer textBuffer = (TextBuffer)this.tp.rows.elementAt(i);
            stringBuffer.append(textBuffer.buf);
            if (i >= n) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    void hPosChange() {
        this.tp.hPosChange();
    }

    public synchronized void insert(String string, int n) {
        this.tp.insert(string, n);
    }

    protected String paramString() {
        return super.paramString();
    }

    void repaintRow(Graphics graphics, int n) {
        this.tp.repaintLine(n, 0, null, graphics);
    }

    public synchronized void replaceRange(String string, int n, int n2) {
        this.tp.replaceRange(string, n, n2);
    }

    void replaceSelectionWith(String string) {
        this.tp.replaceSelectionWith(string);
    }

    public void requestFocus() {
        this.tp.requestFocus();
    }

    public void select(int n, int n2) {
        Point point = this.tp.get2D(n2);
        this.tp.sSel = this.tp.get2D(n);
        this.tp.updateSel(point.x, point.y, true);
    }

    public void selectAll() {
        TextBuffer textBuffer = (TextBuffer)this.tp.rows.lastElement();
        this.tp.sSel.x = 0;
        this.tp.sSel.y = 0;
        this.tp.eSel.x = 0;
        this.tp.eSel.y = 0;
        this.tp.updateSel(textBuffer.len, this.tp.rows.size() - 1, true);
    }

    public void setBackground(Color color) {
        this.tp.setBackground(color);
    }

    public void setCaretPosition(int n) {
        Point point = this.tp.get2D(n);
        this.tp.setCursorPos(point.x, point.y, true, true);
    }

    public void setColumns(int n) {
        this.ccols = n;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.tp.setFont(font);
    }

    public void setForeground(Color color) {
        this.tp.setForeground(color);
    }

    public void setRows(int n) {
    }

    public void setSelectionEnd(int n) {
        Point point = this.tp.get2D(n);
        this.tp.updateSel(point.x, point.y, true);
    }

    public void setSelectionStart(int n) {
        Point point = this.tp.get2D(n);
        this.tp.updateSel(point.x, point.y, true);
    }

    public void setText(String string) {
        this.tp.setContents(string);
    }

    void vPosChange(int n) {
        this.tp.vPosChange(n);
    }

    class TextPane
    extends RowCanvas
    implements KeyListener,
    MouseListener,
    MouseMotionListener {
        TextCursor tCursor = new TextCursor();
        Point sSel = new Point();
        Point eSel = new Point();

        public TextPane() {
            this.xOffsInit = 4;
            this.xOffs = 4;
            this.setCursor(Cursor.getPredefinedCursor(2));
            this.tCursor.setPos(this.xOffs, this.rowHeight + 2 - 1);
            this.insertLine("", 0);
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        void append(String string) {
            this.cursorTextEnd(false);
            this.insert(string, true);
        }

        void backspace() {
            TextBuffer textBuffer = this.getCursorLine();
            if (this.tCursor.index >= 1) {
                textBuffer.remove(this.tCursor.index - 1, 1);
                this.setCursorPos(this.tCursor.index - 1, this.tCursor.yindex, false, true);
                this.repaintLine(this.tCursor.yindex, this.tCursor.index, textBuffer);
            } else if (this.cursorLeft(1, false)) {
                TextBuffer textBuffer2 = this.getCursorLine();
                textBuffer2.append(textBuffer);
                this.rows.removeElement(textBuffer);
                this.repaint();
                this.updateVScroll();
            }
        }

        void blankCursor(Graphics graphics) {
            graphics.setColor(this.getBackground());
            this.tCursor.blank(graphics, this.xOffs, this.getRowYPos(this.tCursor.yindex));
            graphics.setColor(this.getForeground());
            TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(this.tCursor.yindex);
            textBuffer.paint(graphics, this.xOffs, this.tCursor.y, this.rowHeight, this.tCursor.index, 1);
        }

        void cursorDown(int n, boolean bl) {
            int n2 = Math.min(this.tCursor.yindex + n, this.rows.size() - 1);
            if (n2 != this.tCursor.yindex) {
                if (bl) {
                    this.updateSel(this.tCursor.index, n2, true);
                } else {
                    this.setCursorPos(this.tCursor.index, n2, true, true);
                }
            }
        }

        void cursorEnd(boolean bl) {
            TextBuffer textBuffer = this.getCursorLine();
            if (bl) {
                this.updateSel(textBuffer.len, this.tCursor.yindex, true);
            } else {
                this.setCursorPos(textBuffer.len, this.tCursor.yindex, true, true);
            }
        }

        void cursorHome(boolean bl) {
            if (bl) {
                this.updateSel(0, this.tCursor.yindex, true);
            } else {
                this.setCursorPos(0, this.tCursor.yindex, true, true);
            }
        }

        boolean cursorLeft(int n, boolean bl) {
            int n2 = -1;
            int n3 = -1;
            if (this.tCursor.index >= n) {
                n2 = this.tCursor.index - n;
                n3 = this.tCursor.yindex;
            } else if (this.tCursor.yindex > 0) {
                n2 = ((TextBuffer)this.rows.elementAt((int)(this.tCursor.yindex - 1))).len;
                n3 = this.tCursor.yindex - 1;
            }
            if (n3 > -1) {
                if (bl) {
                    this.updateSel(n2, n3, true);
                } else {
                    this.setCursorPos(n2, n3, true, true);
                }
                return true;
            }
            return false;
        }

        void cursorRight(int n, boolean bl) {
            int n2 = -1;
            int n3 = -1;
            TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(this.tCursor.yindex);
            if (textBuffer.len >= this.tCursor.index + n) {
                n2 = this.tCursor.index + n;
                n3 = this.tCursor.yindex;
            } else if (this.tCursor.yindex < this.rows.size() - 1) {
                n2 = 0;
                n3 = this.tCursor.yindex + 1;
            }
            if (n3 > -1) {
                if (bl) {
                    this.updateSel(n2, n3, true);
                } else {
                    this.setCursorPos(n2, n3, true, true);
                }
            }
        }

        void cursorTextEnd(boolean bl) {
            int n = this.rows.size() - 1;
            TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(n);
            if (bl) {
                this.updateSel(textBuffer.len, n, true);
            } else {
                this.setCursorPos(textBuffer.len, n, true, true);
            }
        }

        void cursorTextHome(boolean bl) {
            if (bl) {
                this.updateSel(0, 0, true);
            } else {
                this.setCursorPos(0, 0, true, true);
            }
        }

        void cursorUp(int n, boolean bl) {
            int n2 = Math.max(this.tCursor.yindex - n, 0);
            if (n2 != this.tCursor.yindex) {
                if (bl) {
                    this.updateSel(this.tCursor.index, n2, true);
                } else {
                    this.setCursorPos(this.tCursor.index, n2, true, true);
                }
            }
        }

        void del() {
            TextBuffer textBuffer = this.getCursorLine();
            if (textBuffer.len > this.tCursor.index) {
                textBuffer.remove(this.tCursor.index, 1);
                this.repaintLine(this.tCursor.yindex, this.tCursor.index, textBuffer);
            } else if (this.tCursor.yindex < this.rows.size() - 1) {
                TextBuffer textBuffer2 = (TextBuffer)this.rows.elementAt(this.tCursor.yindex + 1);
                textBuffer.append(textBuffer2);
                this.rows.removeElement(textBuffer2);
                this.repaint();
                this.updateVScroll();
            }
        }

        void deleteSel() {
            Point point = this.getSelStart();
            Point point2 = this.getSelEnd();
            TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(point.y);
            int n = 1;
            if (point.x == point2.x && point.y == point2.y) {
                return;
            }
            if (point.y == point2.y) {
                textBuffer.remove(point.x, point2.x - point.x);
                this.setCursorPos(point.x, point.y, true, true);
                return;
            }
            if (point.x > 0) {
                textBuffer.remove(point.x, textBuffer.len - point.x);
            } else {
                n = 0;
            }
            textBuffer = (TextBuffer)this.rows.elementAt(point2.y);
            textBuffer.remove(0, point2.x);
            for (int i = point.y + n; i < point2.y; ++i) {
                this.rows.removeElementAt(point.y + n);
            }
            this.setCursorPos(point.x, point.y, false, true);
            this.updateVScroll();
            this.repaint();
        }

        public void focusGained(FocusEvent focusEvent) {
            Graphics graphics = this.getClippedGraphics();
            if (graphics != null) {
                this.repaintCursor(graphics);
                graphics.dispose();
            }
            super.focusGained(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            Graphics graphics = this.getClippedGraphics();
            if (graphics != null) {
                this.paintInactiveCursor(graphics);
                graphics.dispose();
            }
            super.focusLost(focusEvent);
            if (this.hasSel()) {
                TextArea.this.copyToClipboard();
            }
        }

        int get1D(Point point) {
            int n = 0;
            for (int i = 0; i < point.y; ++i) {
                TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(i);
                n += textBuffer.len;
            }
            return n += point.x;
        }

        Point get2D(int n) {
            int n2 = this.rows.size();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(i);
                if ((n3 += textBuffer.len) < n) continue;
                return new Point(textBuffer.len - n3 + n, i);
            }
            return new Point(-1, -1);
        }

        int getCol(int n, int n2) {
            TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(n);
            return textBuffer.getIdx(n2 - this.xOffs);
        }

        TextBuffer getCursorLine() {
            return (TextBuffer)this.rows.elementAt(this.tCursor.yindex);
        }

        Point getSelEnd() {
            if (this.sSel.y > this.eSel.y) {
                return this.sSel;
            }
            if (this.sSel.y == this.eSel.y) {
                if (this.sSel.x > this.eSel.x) {
                    return this.sSel;
                }
                return this.eSel;
            }
            return this.eSel;
        }

        Point getSelStart() {
            if (this.sSel.y < this.eSel.y) {
                return this.sSel;
            }
            if (this.sSel.y == this.eSel.y) {
                if (this.sSel.x < this.eSel.x) {
                    return this.sSel;
                }
                return this.eSel;
            }
            return this.eSel;
        }

        boolean hasSel() {
            return this.sSel.x != this.eSel.x || this.sSel.y != this.eSel.y;
        }

        boolean hasSel(int n) {
            if (this.hasSel()) {
                return this.sSel.y <= n || this.eSel.y >= n;
            }
            return false;
        }

        void insert(String string, boolean bl) {
            if (string == null || string.length() == 0) {
                return;
            }
            String[] stringArray = TextArea.this.breakLines(string);
            int n = 0;
            TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(this.tCursor.yindex);
            if (stringArray.length == 0) {
                return;
            }
            if (stringArray.length == 1) {
                int n2 = bl ? this.tCursor.index : this.tCursor.index + stringArray[0].length();
                textBuffer.insert(this.tCursor.index, stringArray[0]);
                this.setCursorPos(n2, this.tCursor.yindex, false, false);
                this.repaintLine(this.tCursor.yindex, 0, textBuffer);
                return;
            }
            String string2 = textBuffer.getString(this.tCursor.index, textBuffer.len - this.tCursor.index);
            textBuffer.remove(this.tCursor.index, textBuffer.len - this.tCursor.index);
            textBuffer.append(stringArray[n++]);
            while (n < stringArray.length) {
                textBuffer = this.insertLine(stringArray[n++], this.tCursor.yindex + n - 1);
            }
            if (!bl) {
                this.setCursorPos(textBuffer.len, this.tCursor.yindex + stringArray.length - 1, false, false);
            }
            textBuffer.append(string2);
            this.updateVScroll();
            this.repaint();
        }

        void insert(String string, int n) {
            Point point = this.get2D(n);
            this.setCursorPos(point.x, point.y, true, true);
            this.insert(string, false);
        }

        void insertChar(char c) {
            TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(this.tCursor.yindex);
            boolean bl = this.tCursor.index == textBuffer.len;
            textBuffer.insert(this.tCursor.index, c);
            if (!bl) {
                int n = this.tCursor.index > 0 ? this.tCursor.index - 1 : this.tCursor.index;
                this.repaintLine(this.tCursor.yindex, n, textBuffer);
            }
            this.cursorRight(1, false);
        }

        TextBuffer insertLine(String string, int n) {
            TextBuffer textBuffer = new TextBuffer(string);
            textBuffer.setMetrics(this.fm, TextArea.this.tabWidth);
            this.rows.insertElementAt(textBuffer, n);
            return textBuffer;
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getModifiers();
            boolean bl = keyEvent.isShiftDown();
            if (TextArea.this.handleClipboard(keyEvent)) {
                keyEvent.consume();
                return;
            }
            if (n2 != 0 && n2 != 1) {
                return;
            }
            switch (n) {
                case 37: {
                    this.cursorLeft(1, bl);
                    break;
                }
                case 39: {
                    this.cursorRight(1, bl);
                    break;
                }
                case 38: {
                    this.cursorUp(1, bl);
                    break;
                }
                case 40: {
                    this.cursorDown(1, bl);
                    break;
                }
                case 9: {
                    if (bl) {
                        return;
                    }
                    this.insertChar('\t');
                    break;
                }
                case 10: {
                    this.newline();
                    break;
                }
                case 8: {
                    if (this.hasSel()) {
                        this.replaceSelectionWith("");
                        break;
                    }
                    this.backspace();
                    break;
                }
                case 127: {
                    if (this.hasSel()) {
                        this.replaceSelectionWith("");
                        break;
                    }
                    this.del();
                    break;
                }
                case 36: {
                    this.cursorHome(bl);
                    break;
                }
                case 35: {
                    this.cursorEnd(bl);
                    break;
                }
                case 33: {
                    this.pageUp(bl);
                    break;
                }
                case 34: {
                    this.pageDown(bl);
                    break;
                }
                case 27: {
                    this.resetSel(true);
                    break;
                }
                default: {
                    return;
                }
            }
            keyEvent.consume();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (!TextArea.this.isEditable || !TextArea.this.isPrintableTyped(keyEvent)) {
                return;
            }
            char c = keyEvent.getKeyChar();
            if (this.hasSel()) {
                Character c2 = new Character(c);
                this.replaceSelectionWith(c2.toString());
            } else {
                this.insertChar(c);
            }
            if (TextArea.this.textListener != null) {
                TextComponent.tEvt.setSource(this.parent);
                this.processTextEvent(TextComponent.tEvt);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = this.getRowIdx(mouseEvent.getY());
            int n2 = this.getCol(n, mouseEvent.getX());
            this.updateSel(n2, n, true);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            switch (n) {
                case 16: {
                    TextArea.this.tp.requestFocus();
                    this.resetSel(true);
                    int n2 = this.getRowIdx(mouseEvent.getY());
                    int n3 = this.getCol(n2, mouseEvent.getX());
                    this.setCursorPos(n3, n2, true, true);
                    break;
                }
                case 8: {
                    TextArea.this.pasteFromClipboard();
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        void newline() {
            String string = "";
            TextBuffer textBuffer = this.getCursorLine();
            if (textBuffer.len > this.tCursor.index) {
                int n = textBuffer.len - this.tCursor.index;
                string = textBuffer.getString(this.tCursor.index, n);
                textBuffer.remove(this.tCursor.index, n);
            }
            TextBuffer textBuffer2 = this.insertLine(string, this.tCursor.yindex + 1);
            textBuffer2.copyLevelFrom(textBuffer);
            this.updateVScroll();
            this.setCursorPos(textBuffer2.getLevel(), this.tCursor.yindex + 1, true, true);
            this.repaintRows(this.tCursor.yindex - 1, this.getVisibleRows());
        }

        void pageDown(boolean bl) {
            int n = this.getVisibleRows();
            int n2 = Math.min(this.tCursor.yindex + n, this.rows.size() - 1);
            if (bl) {
                this.updateSel(this.tCursor.index, n2, true);
            } else {
                this.setCursorPos(this.tCursor.index, n2, true, true);
            }
        }

        void pageUp(boolean bl) {
            int n = this.getVisibleRows();
            int n2 = Math.max(this.tCursor.yindex - n, 0);
            if (bl) {
                this.updateSel(this.tCursor.index, n2, true);
            } else {
                this.setCursorPos(this.tCursor.index, n2, true, true);
            }
        }

        public void paint(Graphics graphics) {
            this.paintBorder(graphics);
            int n = 2;
            graphics.clipRect(n, n, this.width - 2 * n, this.height - 2 * n);
            this.repaintRows(graphics, this.first, this.rows.size() - this.first);
        }

        void paintInactiveCursor(Graphics graphics) {
            graphics.setColor(Defaults.TextCursorInactiveClr);
            this.tCursor.blank(graphics, this.xOffs, this.getRowYPos(this.tCursor.yindex));
        }

        void repaintCursor(Graphics graphics) {
            if (AWTEvent.keyTgt == this) {
                this.tCursor.paint(graphics, this.xOffs, this.getRowYPos(this.tCursor.yindex));
            } else {
                this.paintInactiveCursor(graphics);
            }
        }

        void repaintLine(int n, int n2, TextBuffer textBuffer) {
            Graphics graphics = this.getClippedGraphics();
            if (graphics != null) {
                this.repaintLine(n, n2, textBuffer, graphics);
                graphics.dispose();
            }
        }

        void repaintLine(int n, int n2, TextBuffer textBuffer, Graphics graphics) {
            int n3 = 2;
            if (textBuffer == null) {
                textBuffer = (TextBuffer)this.rows.elementAt(n);
            }
            int n4 = this.selXStart(n);
            int n5 = this.selXEnd(n, textBuffer);
            int n6 = n3 + (n - this.first) * this.rowHeight;
            int n7 = this.tCursor.width;
            if (n4 == n5) {
                int n8 = n2 == 0 ? 0 : textBuffer.getPos(n2) + this.xOffs;
                int n9 = this.width - n8;
                graphics.setColor(this.getBackground());
                graphics.fillRect(n8, n6, n9 - n3, this.rowHeight);
                graphics.setColor(this.getForeground());
                textBuffer.paint(graphics, this.xOffs, n6, this.rowHeight, n2);
            } else {
                int n10;
                int n11;
                if (n4 > n2) {
                    n11 = textBuffer.getPos(n2) + this.xOffs;
                    n10 = textBuffer.getWidth(n2, n4);
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(n11, n6, n10, this.rowHeight);
                    graphics.setColor(this.getForeground());
                    textBuffer.paint(graphics, this.xOffs, n6, this.rowHeight, n2, n4 - n2);
                }
                if (n5 > n2) {
                    n11 = textBuffer.getPos(n4) + this.xOffs;
                    n10 = textBuffer.getWidth(n4, n5);
                    graphics.setColor(Defaults.TextAreaSelBgClr);
                    graphics.fill3DRect(n11, n6, n10, this.rowHeight, true);
                    graphics.setColor(Defaults.TextAreaSelTxtClr);
                    textBuffer.paint(graphics, this.xOffs, n6, this.rowHeight, n4, n5 - n4);
                }
                n11 = textBuffer.getPos(n5) + this.xOffs;
                n10 = this.width - n11;
                graphics.setColor(this.getBackground());
                graphics.fillRect(n11, n6, n10, this.rowHeight);
                if (n5 < textBuffer.len) {
                    graphics.setColor(this.getForeground());
                    textBuffer.paint(graphics, this.xOffs, n6, this.rowHeight, n5);
                }
            }
            if (this.tCursor.yindex == n) {
                this.repaintCursor(graphics);
            }
        }

        void repaintRow(Graphics graphics, int n) {
            this.repaintLine(n, 0, null, graphics);
        }

        void replaceRange(String string, int n, int n2) {
            this.sSel = this.get2D(n);
            this.eSel = this.get2D(n2);
            if (this.sSel.y > -1 && this.eSel.y > -1) {
                this.deleteSel();
            } else {
                this.resetSel(false);
            }
            this.insert(string, true);
        }

        void replaceSelectionWith(String string) {
            this.deleteSel();
            this.insert(string, false);
        }

        void resetSel(boolean bl) {
            boolean bl2 = this.hasSel();
            int n = Math.min(this.sSel.y, this.eSel.y);
            int n2 = Math.max(this.sSel.y, this.eSel.y);
            this.sSel.x = this.tCursor.index;
            this.sSel.y = this.tCursor.yindex;
            this.eSel.x = this.sSel.x;
            this.eSel.y = this.sSel.y;
            if (bl2 && bl) {
                this.repaintRows(n, n2 - n);
            }
        }

        int selXEnd(int n, TextBuffer textBuffer) {
            Point point = this.getSelStart();
            Point point2 = this.getSelEnd();
            if (n > point2.y) {
                return -1;
            }
            if (n < point.y) {
                return -1;
            }
            if (n == point2.y) {
                return point2.x;
            }
            return textBuffer.len;
        }

        int selXStart(int n) {
            Point point = this.getSelStart();
            Point point2 = this.getSelEnd();
            if (n > point2.y) {
                return -1;
            }
            if (n < point.y) {
                return -1;
            }
            if (n == point.y) {
                return point.x;
            }
            return 0;
        }

        void setContents(String string) {
            String[] stringArray = TextArea.this.breakLines(string);
            this.rows.removeAllElements();
            for (int i = 0; i < stringArray.length; ++i) {
                this.insertLine(stringArray[i], i);
            }
            this.setCursorPos(0, 0, false, true);
            this.updateVScroll();
            this.repaint();
        }

        void setCursorPos(int n, int n2, boolean bl, boolean bl2) {
            Graphics graphics = null;
            int n3 = this.tCursor.index;
            if (bl2) {
                this.resetSel(bl);
            }
            if (bl && (graphics = this.getClippedGraphics()) != null) {
                this.blankCursor(graphics);
            }
            this.makeVisible(n2);
            TextBuffer textBuffer = (TextBuffer)this.rows.elementAt(n2);
            this.tCursor.setYIndex(n2, this.getRowYPos(n2));
            if (n > textBuffer.len) {
                n = textBuffer.len;
            }
            int n4 = textBuffer.getPos(n);
            this.tCursor.setIndex(n, n4);
            if (graphics != null) {
                this.repaintCursor(graphics);
                graphics.dispose();
            }
            if (bl2) {
                this.resetSel(false);
            }
            if (this.width > 0) {
                int n5 = 10;
                if (n > n3 && n4 - this.xOffs > this.width - n5) {
                    this.xOffs = this.width - n4 - n5;
                    this.hScroll.setValue(-this.xOffs);
                    this.repaint();
                } else if (n4 + this.xOffs < this.xOffsInit) {
                    this.xOffs = -n4 + this.xOffsInit;
                    this.hScroll.setValue(-this.xOffs);
                    this.repaint();
                }
            }
        }

        public void setFont(Font font) {
            TextBuffer textBuffer;
            int n = this.rows.size();
            super.setFont(font);
            this.fm = this.getFontMetrics(font);
            TextArea.this.tabWidth = 3 * this.fm.charWidth('x');
            this.rowHeight = 4 * this.fm.getHeight() / 3;
            for (int i = 0; i < n; ++i) {
                textBuffer = (TextBuffer)this.rows.elementAt(i);
                textBuffer.setMetrics(this.fm, TextArea.this.tabWidth);
            }
            textBuffer = (TextBuffer)this.rows.elementAt(this.tCursor.yindex);
            this.tCursor.setHeight(this.rowHeight - 1);
            this.tCursor.setYIndex(this.tCursor.yindex, this.getRowYPos(this.tCursor.yindex));
            this.tCursor.setIndex(this.tCursor.index, textBuffer.getPos(this.tCursor.index));
            if (this.isShowing()) {
                this.repaint();
            }
        }

        boolean updateSel(int n, int n2, boolean bl) {
            if (n == this.eSel.x && n2 == this.eSel.y) {
                return false;
            }
            int n3 = Math.min(this.sSel.y, this.eSel.y);
            int n4 = Math.max(this.sSel.y, this.eSel.y);
            this.eSel.x = n;
            this.eSel.y = n2;
            this.setCursorPos(n, n2, false, false);
            if (bl) {
                this.repaintRows(n3, n4 - n3 + 1);
            }
            return true;
        }

        void vPosChange(int n) {
            this.tCursor.setYIndex(this.tCursor.yindex, this.getRowYPos(this.tCursor.yindex));
        }
    }
}

