/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import kaffe.util.Timer;
import kaffe.util.TimerClient;

public class Scrollbar
extends Component
implements Adjustable,
MouseListener,
MouseMotionListener,
TimerClient {
    int min;
    int max;
    int vis;
    int val;
    int ori;
    AdjustmentListener aListener;
    int blockInc;
    int unitInc = 1;
    Rectangle slRect = new Rectangle();
    Graphics dragGr;
    Rectangle dragRect = new Rectangle();
    static int currentOp;
    static Point dragOffs;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    static int SCROLLBAR_WIDTH;

    public Scrollbar() {
        this(1);
    }

    public Scrollbar(int n) throws IllegalArgumentException {
        this(n, 0, 30, 0, 100);
    }

    public Scrollbar(int n, int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        this.bgClr = Defaults.BtnClr;
        this.setOrientation(n);
        this.setValues(n2, n3, n4, n5);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public synchronized void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.aListener = AWTEventMulticaster.add(this.aListener, adjustmentListener);
        this.eventMask |= 0x100;
    }

    public int getBlockIncrement() {
        return this.blockInc;
    }

    int getCurrentOp(int n, int n2) {
        if (this.slRect.contains(n, n2)) {
            Scrollbar.dragOffs.x = n - this.slRect.x;
            Scrollbar.dragOffs.y = n2 - this.slRect.y;
            return 5;
        }
        switch (this.ori) {
            case 1: {
                if (n2 > this.height - this.width) {
                    return 1;
                }
                if (n2 < this.width) {
                    return 2;
                }
                if (n2 < this.slRect.y) {
                    return 3;
                }
                return 4;
            }
            case 0: {
                if (n > this.width - this.height) {
                    return 1;
                }
                if (n < this.height) {
                    return 2;
                }
                if (n < this.slRect.x) {
                    return 3;
                }
                return 4;
            }
        }
        return 0;
    }

    public int getMaximum() {
        return this.max;
    }

    public int getMinimum() {
        return this.min;
    }

    public int getOrientation() {
        return this.ori;
    }

    public Dimension getPreferredSize() {
        if (this.ori == 1) {
            return new Dimension(SCROLLBAR_WIDTH, 100);
        }
        return new Dimension(100, SCROLLBAR_WIDTH);
    }

    public int getUnitIncrement() {
        return this.unitInc;
    }

    public int getValue() {
        return this.val;
    }

    public int getVisibleAmount() {
        return this.vis;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    boolean isSliderShowing() {
        return this.slRect.width > 0;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        currentOp = this.getCurrentOp(mouseEvent.getX(), mouseEvent.getY());
        switch (currentOp) {
            case 3: {
                this.setValue(this.val - this.blockInc);
                break;
            }
            case 4: {
                this.setValue(this.val + this.blockInc);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (currentOp != 5) {
            return;
        }
        Color color = this.parent.getBackground();
        if (this.ori == 1) {
            int n = mouseEvent.getY() - Scrollbar.dragOffs.y;
            int n2 = this.height - this.slRect.height;
            if (n <= 0) {
                if (this.slRect.y >= 0) {
                    this.slRect.y = 0;
                    int n3 = this.dragRect.y;
                    if (n3 > 0) {
                        this.dragGr.setColor(color);
                        this.dragGr.fillRect(this.slRect.x, this.slRect.height, this.slRect.width, n3);
                    }
                    this.paint(this.dragGr);
                }
                if (this.val > this.min) {
                    this.val = this.min;
                    this.notifyAdjust();
                }
            } else if (n >= n2) {
                if (this.slRect.y <= n2) {
                    this.slRect.y = n2;
                    int n4 = this.slRect.y - this.dragRect.y;
                    if (n4 > 0) {
                        this.dragGr.setColor(color);
                        this.dragGr.fillRect(this.slRect.x, this.dragRect.y, this.slRect.width, n4);
                    }
                    this.paint(this.dragGr);
                }
                if (this.val < this.max) {
                    this.val = this.max;
                    this.notifyAdjust();
                }
            } else {
                this.slRect.y = n;
                int n5 = this.slRect.y - this.dragRect.y;
                this.dragGr.setColor(color);
                if (n5 > 0) {
                    this.dragGr.fillRect(this.slRect.x, this.dragRect.y, this.slRect.width, n5);
                } else if (n5 < 0) {
                    this.dragGr.fillRect(this.slRect.x, this.slRect.y + this.slRect.height, this.slRect.width, -n5);
                }
                this.paint(this.dragGr);
                this.updateValue();
            }
            this.dragRect.y = this.slRect.y;
        } else {
            int n = mouseEvent.getX() - Scrollbar.dragOffs.x;
            int n6 = this.width - this.slRect.width;
            if (n <= 0) {
                if (this.slRect.x >= 0) {
                    this.slRect.x = 0;
                    int n7 = this.dragRect.x;
                    if (n7 > 0) {
                        this.dragGr.setColor(color);
                        this.dragGr.fillRect(this.slRect.width, this.slRect.y, n7, this.slRect.height);
                    }
                    this.paint(this.dragGr);
                }
                if (this.val > this.min) {
                    this.val = this.min;
                    this.notifyAdjust();
                }
            } else if (n >= n6) {
                if (this.slRect.x <= n6) {
                    this.slRect.x = n6;
                    int n8 = this.slRect.x - this.dragRect.x;
                    if (n8 > 0) {
                        this.dragGr.setColor(color);
                        this.dragGr.fillRect(this.dragRect.x, this.slRect.y, n8, this.slRect.height);
                    }
                    this.paint(this.dragGr);
                }
                if (this.val < this.max) {
                    this.val = this.max;
                    this.notifyAdjust();
                }
            } else {
                this.slRect.x = n;
                int n9 = this.slRect.x - this.dragRect.x;
                this.dragGr.setColor(color);
                if (n9 > 0) {
                    this.dragGr.fillRect(this.dragRect.x, this.slRect.y, n9, this.slRect.height);
                } else if (n9 < 0) {
                    this.dragGr.fillRect(this.slRect.x + this.slRect.width, this.slRect.y, -n9, this.slRect.height);
                }
                this.paint(this.dragGr);
                this.updateValue();
            }
            this.dragRect.x = this.slRect.x;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        currentOp = this.getCurrentOp(mouseEvent.getX(), mouseEvent.getY());
        this.dragGr = this.getGraphics();
        if (this.dragGr != null) {
            this.dragGr.setColor(this.getBackground());
        }
        this.dragRect.x = this.slRect.x;
        this.dragRect.y = this.slRect.y;
        this.dragRect.width = this.slRect.width;
        this.dragRect.height = this.slRect.height;
        switch (currentOp) {
            case 1: 
            case 2: {
                this.timerExpired(null);
                Timer.getDefaultTimer().addClient(this, 300, 100);
                break;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Timer.getDefaultTimer().removeClient(this);
        Scrollbar.dragOffs.x = 0;
        Scrollbar.dragOffs.y = 0;
        if (this.dragGr != null) {
            this.dragGr.dispose();
            this.dragGr = null;
        }
        switch (currentOp) {
            case 1: 
            case 2: {
                currentOp = 0;
            }
        }
    }

    void notifyAdjust() {
        if (this.hasToNotify(256, this.aListener)) {
            AdjustmentEvent adjustmentEvent = AWTEvent.getAdjustmentEvent(this, 0);
            ((AWTEvent)adjustmentEvent).setAdjustmentEvent(currentOp, this.val);
            Toolkit.eventQueue.postEvent(adjustmentEvent);
        }
    }

    public void paint(Graphics graphics) {
        if (this.slRect.width == 0) {
            graphics.setColor(this.parent.getBackground());
            graphics.fillRect(0, 0, this.width, this.height);
            return;
        }
        graphics.setColor(this.getBackground());
        if (this.ori == 0) {
            int n = this.height / 2 - 1;
            int n2 = this.slRect.x + this.slRect.width;
            if (this.slRect.x > 0) {
                graphics.draw3DRect(0, n, this.slRect.x, 1, true);
            }
            if (n2 < this.width) {
                int n3 = n2 - 1;
                graphics.draw3DRect(n3, n, this.width - n3 - 1, 1, true);
            }
        } else {
            int n = this.width / 2 - 1;
            int n4 = this.slRect.y + this.slRect.height;
            if (this.slRect.y > 0) {
                graphics.draw3DRect(n, 0, 1, this.slRect.y, true);
            }
            if (n4 < this.height) {
                int n5 = n4 - 1;
                graphics.draw3DRect(n, n5, 1, this.height - n5 - 1, true);
            }
        }
        if (this.slRect.width > 0) {
            graphics.fill3DRect(this.slRect.x, this.slRect.y, this.slRect.width, this.slRect.height, true);
        }
    }

    protected String paramString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(super.paramString()).concat(String.valueOf(",Value: "))).concat(String.valueOf(this.val))).concat(String.valueOf(",Visible: "))).concat(String.valueOf(this.vis))).concat(String.valueOf(",Min: "))).concat(String.valueOf(this.min))).concat(String.valueOf(",Max: "))).concat(String.valueOf(this.max));
    }

    protected void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        this.aListener.adjustmentValueChanged(adjustmentEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    public synchronized void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.aListener = AWTEventMulticaster.remove(this.aListener, adjustmentListener);
    }

    public synchronized void setBlockIncrement(int n) {
        this.setValues(this.val, n, this.min, this.max);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.updateSliderRect();
    }

    public synchronized void setMaximum(int n) {
        this.setValues(this.val, this.vis, this.min, n);
    }

    public synchronized void setMinimum(int n) {
        this.setValues(this.val, this.vis, n, this.max);
    }

    public synchronized void setOrientation(int n) throws IllegalArgumentException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this.ori = n;
    }

    public synchronized void setUnitIncrement(int n) {
        this.unitInc = n;
    }

    public synchronized void setValue(int n) {
        if (this.val != n) {
            this.setValues(n, this.vis, this.min, this.max);
        }
    }

    public synchronized void setValues(int n, int n2, int n3, int n4) {
        int n5 = this.val;
        if (n4 < n3) {
            n4 = n3;
        }
        if (n > n4) {
            n = n4;
        }
        if (n < n3) {
            n = n3;
        }
        if (n2 > n4 - n3) {
            n2 = n4 - n3;
        }
        this.min = n3;
        this.max = n4;
        this.val = n;
        this.vis = n2;
        this.blockInc = n2;
        if (this.val < n3) {
            if (this.val == n3) {
                return;
            }
            this.val = n3;
        } else if (this.val > this.max) {
            if (this.val == this.max) {
                return;
            }
            this.val = this.max;
        }
        this.update();
        if (this.val != n5) {
            this.notifyAdjust();
        }
    }

    public synchronized void setVisibleAmount(int n) {
        this.setValues(this.val, n, this.min, this.max);
    }

    public void timerExpired(Timer timer) {
        switch (currentOp) {
            case 2: {
                if (this.val == this.min) {
                    Timer.getDefaultTimer().removeClient(this);
                    break;
                }
                this.setValue(this.val - this.unitInc);
                break;
            }
            case 1: {
                if (this.val == this.max) {
                    Timer.getDefaultTimer().removeClient(this);
                    break;
                }
                this.setValue(this.val + this.unitInc);
            }
        }
    }

    void update() {
        Graphics graphics = this.dragGr != null ? this.dragGr : this.getGraphics();
        if (graphics != null) {
            graphics.setColor(this.parent.getBackground());
            graphics.fillRect(this.slRect.x, this.slRect.y, this.slRect.width, this.slRect.height);
            this.updateSliderRect();
            this.paint(graphics);
            if (graphics != this.dragGr) {
                graphics.dispose();
            }
        } else {
            this.updateSliderRect();
        }
    }

    void updateSliderRect() {
        int n = this.max - this.min;
        if (n <= 0 || this.vis <= 0) {
            this.slRect.setBounds(0, 0, 0, 0);
            return;
        }
        if (this.ori == 0) {
            int n2 = Math.max(this.vis * this.width / (n + this.vis), 10);
            int n3 = this.val * (this.width - n2) / n;
            if (n3 >= 0) {
                this.slRect.setBounds(n3, 2, n2, this.height - 4);
            } else {
                this.slRect.setBounds(0, 0, 0, 0);
            }
        } else {
            int n4 = Math.max(this.vis * this.height / (n + this.vis), 10);
            int n5 = this.val * (this.height - n4) / n;
            if (n5 >= 0) {
                this.slRect.setBounds(2, n5, this.width - 4, n4);
            } else {
                this.slRect.setBounds(0, 0, 0, 0);
            }
        }
    }

    void updateValue() {
        int n = this.ori == 0 ? this.slRect.x * (this.max - this.min) / (this.width - this.slRect.width) : this.slRect.y * (this.max - this.min) / (this.height - this.slRect.height);
        if (this.val != n) {
            this.val = n;
            this.notifyAdjust();
        }
    }

    static {
        dragOffs = new Point();
        SCROLLBAR_WIDTH = 14;
    }
}

