/*
 * Decompiled with CFR 0.152.
 */
package pizza.util;

import java.io.Serializable;
import pizza.util.Enumeration;
import pizza.util.SetEntry;
import pizza.util.SetEnumerator;

public class Set
implements Serializable,
Cloneable {
    private SetEntry[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public Set(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new SetEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public Set(int n) {
        this(n, 0.75f);
    }

    public Set() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration pizza$util$Set$elements() {
        return new SetEnumerator(this.table);
    }

    public synchronized boolean pizza$util$Set$contains(Object object) {
        SetEntry[] setEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % setEntryArray.length;
        SetEntry setEntry = setEntryArray[n2];
        while (setEntry != null) {
            if (setEntry.hash == n && setEntry.elem.equals(object)) {
                return true;
            }
            setEntry = setEntry.next;
        }
        return false;
    }

    protected void rehash() {
        int n = this.table.length;
        SetEntry[] setEntryArray = this.table;
        int n2 = n * 2 + 1;
        SetEntry[] setEntryArray2 = new SetEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = setEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            SetEntry setEntry = setEntryArray[n3];
            while (setEntry != null) {
                SetEntry setEntry2 = setEntry;
                setEntry = setEntry.next;
                int n4 = (setEntry2.hash & Integer.MAX_VALUE) % n2;
                setEntry2.next = setEntryArray2[n4];
                setEntryArray2[n4] = setEntry2;
            }
        }
    }

    public synchronized void pizza$util$Set$put(Object object) {
        SetEntry[] setEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % setEntryArray.length;
        SetEntry setEntry = setEntryArray[n2];
        while (setEntry != null) {
            if (setEntry.hash == n && setEntry.elem.equals(object)) {
                return;
            }
            setEntry = setEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            this.pizza$util$Set$put(object);
        }
        setEntryArray[n2] = new SetEntry(object, n, setEntryArray[n2]);
        ++this.count;
    }

    public synchronized boolean pizza$util$Set$remove(Object object) {
        SetEntry[] setEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % setEntryArray.length;
        SetEntry setEntry = setEntryArray[n2];
        SetEntry setEntry2 = null;
        while (setEntry != null) {
            if (setEntry.hash == n && setEntry.elem.equals(object)) {
                if (setEntry2 != null) {
                    setEntry2.next = setEntry.next;
                } else {
                    setEntryArray[n2] = setEntry.next;
                }
                --this.count;
                return true;
            }
            setEntry2 = setEntry;
            setEntry = setEntry.next;
        }
        return false;
    }

    public synchronized void clear() {
        SetEntry[] setEntryArray = this.table;
        int n = setEntryArray.length;
        while (--n >= 0) {
            setEntryArray[n] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        Set set = new Set(this.table.length, this.loadFactor);
        int n = this.table.length;
        while (n-- > 0) {
            set.table[n] = this.table[n] != null ? this.table[n].pizza$util$SetEntry$copy() : null;
        }
        return set;
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.pizza$util$Set$elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.pizza$util$Enumeration$nextElement().toString();
            stringBuffer.append(string);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

