// $Id: WrapPromotedWrite.java,v 1.1 1999/10/09 23:46:19 oliva Exp $

/* Copyright 1999 Alexandre Oliva <oliva@lsd.ic.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

import BR.unicamp.Guarana.*;

/**
 * This test verifies that promoted field writes are wrapped
 * correctly.
 *
 * Based on bug report by Luciano Garcia <lgarcia@cci.uatx.mx>
 *
 * @author Alexandre Oliva
 * @version $Revision: 1.1 $ */
public class WrapPromotedWrite extends MetaObject {
    public byte b;
    public char c;
    public short s;
    public float f;

    public static void main(final String[] argv) {
	WrapPromotedWrite o = new WrapPromotedWrite();
	Guarana.reconfigure(o, null, new WrapPromotedWrite());
	o.b = 98;
	o.c = 'c';
	o.s = 5;
	o.f = 100f;
    }

    public Result handle(final Operation op, final Object o) {
	System.out.println(op.getField() + ": " + op.getValue());
	return null;
    }
}

/* Expected output:
public byte WrapPromotedWrite.b: 98
public char WrapPromotedWrite.c: c
public short WrapPromotedWrite.s: 5
public float WrapPromotedWrite.f: 100.0
*/
