/*
 * GuaranaIntrn.h
 * Internal declarations used by Guarana
 *
 * Copyright 1997,1998,1999,2000 Alexandre Oliva <oliva@lsd.ic.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GuaranaIntrn_h
#define _GuaranaIntrn_h

#include "config.h"
#include "config-std.h"
#include "config-mem.h"

#include "native.h"
#include "jni.h"

#include "Arrays.h"
#include "access.h"
#include "classMethod.h"
#include "exception.h"
#include "locks.h"
#include "machine.h"
#include "object.h"
#include "soft.h"
#include "support.h"
#include "baseClasses.h"
#include "thread.h"

#include "GuaraNative.h"
#include "BR_unicamp_Guarana_Guarana.h"
#include "BR_unicamp_Guarana_Operation.h"
#include "BR_unicamp_Guarana_OperationFactoryInternal.h"
#include "BR_unicamp_Guarana_Result.h"

typedef HArrayOfObject Array;

#define ALLOC_ARGVEC_FOR(nargs) (jvalue*)gc_malloc(nargs*sizeof(jvalue), GC_ALLOC_NOWALK)

struct wrapArgVec {
  int len;
  struct Hjava_lang_Object *args[1];
};

#define JREF_TO_ARGVEC(ref) ((struct wrapArgVec*)ref)

typedef struct HNativeResult {
  struct Hjava_lang_Object base;
  enum result_type {
    res_noResult = BR_unicamp_Guarana_Result_noResultMode,
    res_inspect = BR_unicamp_Guarana_Result_inspectResultMode,
    res_modify = BR_unicamp_Guarana_Result_modifyResultMode,
    res_reqMask = BR_unicamp_Guarana_Result_resultRequestMask,
    res_returned = BR_unicamp_Guarana_Result_returnedValue,
    res_thrown = BR_unicamp_Guarana_Result_thrownValue,
    res_resMask = BR_unicamp_Guarana_Result_resultValueMask
  } kind;
  struct HBR_unicamp_Guarana_Operation* op;
  jvalue res;
} NativeResult;

typedef struct HNativeOperation {
  struct Hjava_lang_Object base;
  struct Hjava_lang_Object *object;
  struct Hjava_lang_Thread *thread;
  struct HBR_unicamp_Guarana_Operation *replaced;
  enum operation_type {
    op_nop = BR_unicamp_Guarana_Operation_nop,
    op_method_invocation = BR_unicamp_Guarana_Operation_methodInvocation,
    op_constructor_invocation = BR_unicamp_Guarana_Operation_constructorInvocation,
    op_invocation = BR_unicamp_Guarana_Operation_invocation,
    op_monitor_enter = BR_unicamp_Guarana_Operation_monitorEnter,
    op_monitor_exit = BR_unicamp_Guarana_Operation_monitorExit,
    op_synchronization = BR_unicamp_Guarana_Operation_synchronization,
    op_read = BR_unicamp_Guarana_Operation_read,
    op_write = BR_unicamp_Guarana_Operation_write,
    op_read_write_mask = BR_unicamp_Guarana_Operation_readWriteMask,
    op_array_length = BR_unicamp_Guarana_Operation_arrayLength,
    op_field_read = BR_unicamp_Guarana_Operation_fieldRead,
    op_field_write = BR_unicamp_Guarana_Operation_fieldWrite,
    op_array_read = BR_unicamp_Guarana_Operation_arrayRead,
    op_array_write = BR_unicamp_Guarana_Operation_arrayWrite,
    op_field = BR_unicamp_Guarana_Operation_field,
    op_array = BR_unicamp_Guarana_Operation_array,
    op_array_mask = BR_unicamp_Guarana_Operation_arrayMask,
    op_kind_mask = op_method_invocation|op_constructor_invocation|op_synchronization|op_read_write_mask|op_field|op_array_mask,
    op_wrapped = op_kind_mask+1
  } kind;
  union {
    struct _methods *method;
    struct {
      Hjava_lang_Class *clazz;
      struct _fields* field;
    } field_id;
    jint index;
  } op_id;
  jvalue op_arg;
  struct Hjava_util_Hashtable *MOinfo;
} NativeOperation;

typedef struct HOperationFactoryInternal {
  struct Hjava_lang_Object base;
  struct Hjava_lang_Object *obj;
  struct HBR_unicamp_Guarana_MetaObject *mobj;
} OperationFactory;

#endif
