/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class HttpUtils {
    public static Hashtable parseQueryString(String string) {
        int n;
        Hashtable hashtable = new Hashtable();
        int n2 = 0;
        while ((n = string.indexOf(61, n2)) != -1) {
            int n3 = string.indexOf(38, n);
            if (n3 == -1) {
                n3 = string.length();
            }
            HttpUtils.add(hashtable, string.substring(n2, n - 1), string.substring(n + 1, n3));
            n2 = n3 + 1;
        }
        return hashtable;
    }

    private static void add(Hashtable hashtable, String string, String string2) {
        string = HttpUtils.parse(string);
        string2 = HttpUtils.parse(string2);
        String[] stringArray = (String[])hashtable.get(string);
        if (stringArray == null) {
            stringArray = new String[]{string2};
        } else {
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray = stringArray2;
        }
        hashtable.put(string, stringArray);
    }

    private static String parse(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(n + 1, n + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        throw new IllegalArgumentException();
                    }
                    n += 2;
                    break;
                }
                case '+': {
                    stringBuffer.append(' ');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Hashtable parsePostData(int n, ServletInputStream servletInputStream) {
        byte[] byArray = new byte[n];
        try {
            servletInputStream.read(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("bad POST data");
        }
        return HttpUtils.parseQueryString(new String(byArray));
    }

    public static StringBuffer getRequestURL(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(httpServletRequest.getScheme());
        stringBuffer.append("://");
        stringBuffer.append(httpServletRequest.getServerName());
        int n = httpServletRequest.getServerPort();
        if (n != 80) {
            stringBuffer.append(':');
            stringBuffer.append(n);
        }
        stringBuffer.append(httpServletRequest.getServletPath());
        return stringBuffer;
    }
}

