/*
 * Decompiled with CFR 0.152.
 */
package kaffe.util;

import kaffe.util.TimerClient;
import kaffe.util.TimerClientEntry;

public class Timer
extends Thread {
    static Timer defaultTimer;
    TimerClientEntry[] clients;
    int nClients;
    int resolution = Integer.MAX_VALUE;
    boolean stop;

    public synchronized boolean addClient(TimerClient timerClient, int n, int n2) {
        int n3 = 0;
        while (n3 < this.nClients) {
            if (this.clients[n3].client == timerClient) {
                return false;
            }
            ++n3;
        }
        if (this.nClients == this.clients.length) {
            TimerClientEntry[] timerClientEntryArray = new TimerClientEntry[this.clients.length + 10];
            System.arraycopy(this.clients, 0, timerClientEntryArray, 0, this.nClients);
            this.clients = timerClientEntryArray;
            n3 = this.nClients;
            while (n3 < this.clients.length) {
                this.clients[n3] = new TimerClientEntry();
                ++n3;
            }
        }
        TimerClientEntry timerClientEntry = this.clients[this.nClients++];
        timerClientEntry.client = timerClient;
        timerClientEntry.nextNotify = System.currentTimeMillis() + (long)n;
        timerClientEntry.interval = n2;
        if (n2 < this.resolution) {
            this.resolution = n2;
            this.interrupt();
        }
        if (this.nClients == 1) {
            this.notify();
        }
        return true;
    }

    public static synchronized Timer getDefaultTimer() {
        if (defaultTimer == null) {
            defaultTimer = new Timer();
        }
        return defaultTimer;
    }

    public synchronized boolean removeClient(TimerClient timerClient) {
        int n = 0;
        while (n < this.nClients) {
            TimerClientEntry timerClientEntry = this.clients[n];
            if (timerClientEntry.client == timerClient) {
                int n2 = n + 1;
                int n3 = this.nClients - 1;
                timerClientEntry.client = null;
                if (n2 < n3) {
                    System.arraycopy(this.clients, n2, this.clients, n, n3 - n);
                }
                this.clients[--this.nClients] = timerClientEntry;
                if (this.resolution == timerClientEntry.interval && this.nClients > 0) {
                    n = 0;
                    int n4 = Integer.MAX_VALUE;
                    while (n < this.nClients) {
                        if (this.clients[n].interval < n4) {
                            n4 = this.clients[n].interval;
                        }
                        ++n;
                    }
                    if (n4 != this.resolution) {
                        this.resolution = n4;
                    }
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    public void run() {
        while (!this.stop) {
            try {
                while (!this.stop) {
                    Timer timer = this;
                    synchronized (timer) {
                        if (this.nClients == 0) {
                            this.wait();
                        }
                        long l = System.currentTimeMillis();
                        int n = 0;
                        while (n < this.nClients) {
                            TimerClientEntry timerClientEntry = this.clients[n];
                            if (l > timerClientEntry.nextNotify) {
                                timerClientEntry.client.timerExpired(this);
                                timerClientEntry.nextNotify = l + (long)timerClientEntry.interval;
                            }
                            ++n;
                        }
                    }
                    if (this.nClients <= 0) continue;
                    Thread.sleep(this.resolution);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void startNotify() {
        this.stop = false;
        this.start();
    }

    public void stopNotify() {
        this.stop = true;
    }

    public Timer() {
        this.clients = new TimerClientEntry[5];
        int n = 0;
        while (n < this.clients.length) {
            this.clients[n] = new TimerClientEntry();
            ++n;
        }
        this.setDaemon(true);
        this.start();
    }
}

