/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractCollection
implements Collection {
    public abstract Iterator iterator();

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            boolean bl = object == null ? object2 == null : object.equals(object2);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        Iterator iterator = this.iterator();
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = iterator.next();
            ++n;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        Iterator iterator = this.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            objectArray[n2] = iterator.next();
            ++n2;
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            boolean bl = object == null ? object2 == null : object.equals(object2);
            if (!bl) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return true;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        Iterator iterator = this.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public void clear() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.remove();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        stringBuffer.append("[");
        while (iterator.hasNext()) {
            Object object = iterator.next();
            stringBuffer.append(String.valueOf(object));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected AbstractCollection() {
    }
}

