/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileInputStream
extends InputStream {
    private FileDescriptor fd = new FileDescriptor();

    public native int available() throws IOException;

    public native void close() throws IOException;

    protected void finalize() throws IOException {
        this.close();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getMessage());
        }
    }

    public final FileDescriptor getFD() throws IOException {
        return this.fd;
    }

    private native void open(String var1) throws IOException;

    public native int read() throws IOException;

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n >= 0 && n + n2 <= byArray.length) {
            return this.readBytes(byArray, n, n2);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    private native int readBytes(byte[] var1, int var2, int var3);

    public native long skip(long var1) throws IOException;

    public FileInputStream(File file) throws FileNotFoundException {
        this(file.getPath());
    }

    public FileInputStream(FileDescriptor fileDescriptor) {
        System.getSecurityManager().checkRead(fileDescriptor);
        this.fd = fileDescriptor;
    }

    public FileInputStream(String string) throws FileNotFoundException {
        System.getSecurityManager().checkRead(string);
        try {
            this.open(string);
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(string + ": " + iOException.getMessage());
        }
    }

    static {
        System.loadLibrary("io");
    }
}

