/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

public class CharArrayWriter
extends Writer {
    private static final int DEFAULTBUFFERSIZE = 64;
    private static final int DEFAULTBUFFERSPILL = 64;
    protected char[] buf;
    protected int count = 0;

    public void write(int n) {
        char[] cArray = new char[]{(char)n};
        this.write(cArray, 0, 1);
    }

    public void write(char[] cArray, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.count + n2 > this.buf.length) {
                char[] cArray2 = this.buf;
                this.buf = new char[this.count + n2 + 64];
                System.arraycopy(cArray2, 0, this.buf, 0, this.count);
            }
            System.arraycopy(cArray, n, this.buf, this.count, n2);
            this.count += n2;
        }
    }

    public void write(String string, int n, int n2) {
        this.write(string.toCharArray(), n, n2);
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write(this.buf, 0, this.count);
    }

    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.count = 0;
        }
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.count];
        System.arraycopy(this.buf, 0, cArray, 0, this.count);
        return cArray;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public void flush() {
    }

    public void close() {
    }

    public CharArrayWriter() {
        this(64);
    }

    public CharArrayWriter(int n) {
        this.buf = new char[n];
    }
}

