/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Toolkit;
import java.io.Serializable;

public class Color
implements Serializable {
    public static final Color darkGray = new Color(64, 64, 64);
    public static final Color black = new Color(0, 0, 0);
    public static final Color red = new Color(-1, 0, 0);
    public static final Color pink = new Color(-1, -81, -81);
    public static final Color orange = new Color(-1, -56, 0);
    public static final Color yellow = new Color(-1, -1, 0);
    public static final Color green = new Color(0, -1, 0);
    public static final Color magenta = new Color(-1, 0, -1);
    public static final Color cyan = new Color(0, -1, -1);
    public static final Color blue = new Color(0, 0, -1);
    public static final Color white = new Color(-1, -1, -1);
    public static final Color lightGray = new Color(-64, -64, -64);
    public static final Color gray = new Color(-128, -128, -128);
    private static final long serialVersionUID = 118526816881161077L;
    int rgbValue;
    int nativeValue = -1;
    Color brighter;
    Color darker;

    public static int HSBtoRGB(float f, float f2, float f3) {
        int n;
        int n2;
        int n3;
        if ((double)f3 == 0.0) {
            return -16777216;
        }
        if ((double)f2 == 0.0) {
            int n4 = (int)(f3 * 255.0f + 0.5f);
            return n4 << 16 | n4 << 8 | n4 | 0xFF000000;
        }
        int n5 = (int)Math.floor(f *= 6.0f);
        if (n5 == 6) {
            n5 = 0;
        }
        float f4 = f - (float)n5;
        int n6 = (int)((f3 *= 255.0f) + 0.5f);
        int n7 = (int)((1.0f - f2) * f3 + 0.5f);
        int n8 = (int)((1.0f - f2 * f4) * f3 + 0.5f);
        int n9 = (int)((1.0f - f2 * (1.0f - f4)) * f3 + 0.5f);
        switch (n5) {
            case 0: {
                n3 = n6;
                n2 = n9;
                n = n7;
                break;
            }
            case 1: {
                n3 = n8;
                n2 = n6;
                n = n7;
                break;
            }
            case 2: {
                n3 = n7;
                n2 = n6;
                n = n9;
                break;
            }
            case 3: {
                n3 = n7;
                n2 = n8;
                n = n6;
                break;
            }
            case 4: {
                n3 = n9;
                n2 = n7;
                n = n6;
                break;
            }
            case 5: {
                n3 = n6;
                n2 = n7;
                n = n8;
                break;
            }
            default: {
                n3 = 0;
                n2 = 0;
                n = 0;
            }
        }
        return n3 << 16 | n2 << 8 | n | 0xFF000000;
    }

    public static float[] RGBtoHSB(int n, int n2, int n3, float[] fArray) {
        float f;
        float f2;
        float f3 = (float)n / 255.0f;
        float f4 = (float)n2 / 255.0f;
        float f5 = (float)n3 / 255.0f;
        if (fArray == null) {
            fArray = new float[3];
        }
        if (n > n2) {
            f2 = n > n3 ? f3 : f5;
            f = n3 < n2 ? f5 : f4;
        } else {
            f2 = n3 > n2 ? f5 : f4;
            f = n < n3 ? f3 : f5;
        }
        fArray[2] = f2;
        if (f2 > 0.0f) {
            float f6 = f2 - f;
            fArray[1] = f6 / f2;
            if (f6 > 0.0f) {
                fArray[0] = f2 == f3 ? (f4 - f5) / f6 / 6.0f : (f2 == f4 ? (2.0f + (f5 - f3) / f6) / 6.0f : (4.0f + (f3 - f4) / f6) / 6.0f);
                if (fArray[0] < 0.0f) {
                    fArray[0] = fArray[0] + 1.0f;
                }
            } else {
                fArray[0] = 0.0f;
            }
        } else {
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
        }
        return fArray;
    }

    public Color brighter() {
        if (this.brighter == null) {
            this.brighter = new Color(Toolkit.clrBright(this.rgbValue));
        }
        return this.brighter;
    }

    public Color darker() {
        if (this.darker == null) {
            this.darker = new Color(Toolkit.clrDark(this.rgbValue));
        }
        return this.darker;
    }

    public static Color decode(String string) throws NumberFormatException {
        return new Color(Integer.decode(string));
    }

    public boolean equals(Object object) {
        return object instanceof Color && ((Color)object).rgbValue == this.rgbValue;
    }

    public int getBlue() {
        return this.rgbValue & 0xFF;
    }

    public static Color getColor(String string) {
        return Color.getColor(string, null);
    }

    public static Color getColor(String string, Color color) {
        Integer n = Integer.getInteger(string);
        if (n == null) {
            return color;
        }
        return new Color(n);
    }

    public static Color getColor(String string, int n) {
        Integer n2 = Integer.getInteger(string);
        if (n2 == null) {
            return new Color(n);
        }
        return new Color(n2);
    }

    public int getGreen() {
        return (this.rgbValue & 0xFF00) >> 8;
    }

    public static Color getHSBColor(float f, float f2, float f3) {
        return new Color(Color.HSBtoRGB(f, f2, f3));
    }

    public int getRGB() {
        return this.rgbValue;
    }

    public int getRed() {
        return (this.rgbValue & 0xFF0000) >> 16;
    }

    public int hashCode() {
        return this.rgbValue;
    }

    void setNativeValue() {
        this.nativeValue = Toolkit.clrGetPixelValue(this.rgbValue);
    }

    public String toString() {
        return "Color [r=" + this.getRed() + ",g=" + this.getGreen() + ",b=" + this.getBlue() + "]";
    }

    private Color(byte by, byte by2, byte by3) {
        this.rgbValue = 0xFF000000 | (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
    }

    public Color(float f, float f2, float f3) {
        this.rgbValue = 0xFF000000 | ((int)(f * 255.0f) & 0xFF) << 16 | ((int)(f2 * 255.0f) & 0xFF) << 8 | (int)(f3 * 255.0f) & 0xFF;
        this.nativeValue = Toolkit.clrGetPixelValue(this.rgbValue);
    }

    public Color(int n) {
        this.rgbValue = n | 0xFF000000;
        this.nativeValue = Toolkit.clrGetPixelValue(this.rgbValue);
    }

    public Color(int n, int n2, int n3) {
        this.rgbValue = 0xFF000000 | (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF;
        this.nativeValue = Toolkit.clrGetPixelValue(this.rgbValue);
    }

    Color(long l) {
        this.rgbValue = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.nativeValue = Toolkit.clrGetPixelValue(this.rgbValue);
    }

    static {
        try {
            Class.forName("java.awt.Defaults");
        }
        catch (Exception exception) {
            // empty catch block
        }
        gray.setNativeValue();
        darkGray.setNativeValue();
        black.setNativeValue();
        red.setNativeValue();
        pink.setNativeValue();
        orange.setNativeValue();
        yellow.setNativeValue();
        green.setNativeValue();
        magenta.setNativeValue();
        cyan.setNativeValue();
        blue.setNativeValue();
        white.setNativeValue();
        lightGray.setNativeValue();
    }
}

