/* machine.h
 *
 * Copyright (c) 1996, 1997
 *	Transvirtual Technologies, Inc.  All rights reserved.
 *
 * See the file "license.terms" for information on usage and redistribution 
 * of this file. 
 */

#ifndef __machine_h
#define __machine_h

/* -------------------------------------------------------------------- */

/* Instructions */
#define	define_insn(code)	break;					\
				case code :
#define	define_insn_alias(code)	case code :

/* Stack */
#define	push(_i)		stackno -= (_i)
#define	pop(_i)			stackno += (_i)

/* PC */
#define	getopcode()		((int)base[pc])
#define	getpc(_p)		base[pc+1+(_p)]
#define	getcode(_p)		base[(_p)]
#define	adjustpc(_p)		npc = pc + (_p)

#define current_class()		(meth->class)

/* -------------------------------------------------------------------- */
/* Methods */

#define	get_method_info(idx)  \
  if (getMethodSignatureClass(idx, meth->class, true, false, &cinfo, einfo) \
	== false) { success = false; goto done; }

#define	get_special_method_info(idx)  \
  if (getMethodSignatureClass(idx, meth->class, true, true, &cinfo, einfo) \
	== false) { success = false; goto done; } 

#define	method_name()	(cinfo.name)
#define	method_sig()	(cinfo.signature)
#define	method_idx()	(cinfo.method->idx)
#define method_method()	(cinfo.method)
#define method_class()  (cinfo.class)
#define	get_dispatch_table(mtable)				\
			move_ref_const(mtable, cinfo.class->dtable)

#define	method_nargs()		(cinfo.in)
#define	method_dtable_offset	(OBJECT_DTABLE_OFFSET)
#define	method_returntype()	(cinfo.rettype)

/* -------------------------------------------------------------------- */
/* Fields */

#define	get_field_info(IDX) \
  if (getField((IDX), meth->class, false, &finfo, einfo) == false) { \
    success = false; goto done; \
  }

#define	get_static_field_info(IDX) \
  if (getField((IDX), meth->class, true, &finfo, einfo) == false) { \
    success = false; goto done; \
  }

#define field_class()		(finfo.class)

/* -------------------------------------------------------------------- */
/* Classes */

#define	get_class_info(IDX)	\
  crinfo = getClass((IDX), meth->class, einfo); \
  if (crinfo == 0) { \
    success = false; goto done; \
  }

#define	class_object()		(crinfo)

/* -------------------------------------------------------------------- */
/* Objects */

#define	object_array_offset	(ARRAY_DATA_OFFSET)
#define	object_array_length	(ARRAY_SIZE_OFFSET)

/* -------------------------------------------------------------------- */
/* Switches */

#define	switchpair_size		8
#define	switchpair_addr		4
#define	switchtable_shift	2

/* Provide write barrier support for incremental GC */
#if defined(GC_INCREMENTAL)
#define	SOFT_ADDREFERENCE(_f, _t)	 softcall_addreference(_f, _t)
#define	SOFT_ADDREFERENCE_STATIC(_f, _t) softcall_addreference_static(_f, _t)
#else
#define	SOFT_ADDREFERENCE(_f, _t)
#define	SOFT_ADDREFERENCE_STATIC(_f, _t)
#endif

struct _methods;
bool translate(struct _methods*, errorInfo*);

#if GUARANA
#define	softcall_new(r, t)			softcall_new_((r), (t), meth)
#define	softcall_newarray(r, s, t)		softcall_newarray_((r), (s), (t), meth)
#define	softcall_anewarray(r, s, t)		softcall_anewarray_((r), (s), (t), meth)
#define	softcall_multianewarray(r, z, s, t)	softcall_multianewarray_((r), (z), (s), (t), meth)

#define build_call_frame(sig, obj, sp) build_call_frame_guarana((sig), (obj), (sp), 0)

#define softcall_reify_method_invocation(method) do { \
  end_sub_block(); \
  prepare_function_call() ; \
  if (method_method()->accflags & ACC_STATIC) {\
    build_call_frame_guarana(method_sig(), 0, idx, 2); \
    pusharg_ref_const(0, 1); \
  } else { \
    build_call_frame_guarana(method_sig(), stack(idx), idx, 1); \
  } \
  pusharg_ref((method), 0); \
  switch (low) { \
  case 'V': \
    call_soft(jvoid_reify_method_invocation); \
    break; \
  case 'L': \
  case '[': \
    call_soft(jref_reify_method_invocation); \
    break; \
  case 'Z': \
    call_soft(jboolean_reify_method_invocation); \
    break; \
  case 'C': \
    call_soft(jchar_reify_method_invocation); \
    break; \
  case 'B': \
    call_soft(jbyte_reify_method_invocation); \
    break; \
  case 'S': \
    call_soft(jshort_reify_method_invocation); \
    break; \
  case 'I': \
    call_soft(jint_reify_method_invocation); \
    break; \
  case 'J': \
    call_soft(jlong_reify_method_invocation); \
    break; \
  case 'F': \
    call_soft(jfloat_reify_method_invocation); \
    break; \
  case 'D': \
    call_soft(jdouble_reify_method_invocation); \
    break; \
  default: \
    ABORT(); \
  } \
  popargs(); \
  fixup_function_call(); \
  start_sub_block(); \
} while (0)

#define softcall_reify_field_load(obj) do { \
  void *func = 0; SlotInfo *slot = 0; void (*retfunc)(SlotInfo *) = 0; \
  prepare_function_call(); \
  pusharg_ref_const(finfo.field, 2); \
  pusharg_ref_const(finfo.class, 1); \
  pusharg_ref((obj), 0); \
  if (FIELD_ISREF(finfo.field)) { \
    func = jref_reify_field_load; slot = wstack(0); retfunc = return_ref; \
  } else switch (CLASS_PRIM_SIG(FIELD_TYPE(finfo.field))) { \
  case 'Z': \
    func = jboolean_reify_field_load; slot = wstack(0); retfunc = return_int; \
    break; \
  case 'C': \
    func = jchar_reify_field_load; slot = wstack(0); retfunc = return_int; \
    break; \
  case 'B': \
    func = jbyte_reify_field_load; slot = wstack(0); retfunc = return_int; \
    break; \
  case 'S': \
    func = jshort_reify_field_load;  slot = wstack(0); retfunc = return_int; \
    break; \
  case 'I': \
    func = jint_reify_field_load; slot = wstack(0); retfunc = return_int; \
    break; \
  case 'J': \
    func = jlong_reify_field_load; push(1); slot = stack_long(0); retfunc = return_long; \
    break; \
  case 'F': \
    func = jfloat_reify_field_load; slot = wstack(0); retfunc = return_float; \
    break; \
  case 'D': \
    func = jdouble_reify_field_load; push(1); slot = stack_double(0); retfunc = return_double; \
    break; \
  default: \
    ABORT(); \
  } \
  call_soft(func); \
  popargs(); \
  fixup_function_call(); \
  retfunc(slot); \
} while (0)

#ifndef pusharg_char
#define pusharg_char pusharg_int
#endif
#ifndef pusharg_bool
#define pusharg_bool pusharg_int
#endif
#ifndef pusharg_byte
#define pusharg_byte pusharg_int
#endif
#ifndef pusharg_short
#define pusharg_short pusharg_int
#endif

#define softcall_reify_field_store(obj) do { \
  void *func = 0; \
  prepare_function_call(); \
  if (FIELD_ISREF(finfo.field)) { \
    pusharg_ref(rstack(0), 3); pop(1); func = jref_reify_field_store; \
  } else switch (CLASS_PRIM_SIG(FIELD_TYPE(finfo.field))) { \
  case 'Z': \
    pusharg_bool(rstack(0), 3); pop(1); func = jboolean_reify_field_store; \
    break; \
  case 'C': \
    pusharg_char(rstack(0), 3); pop(1); func = jchar_reify_field_store; \
    break; \
  case 'B': \
    pusharg_byte(rstack(0), 3); pop(1); func = jbyte_reify_field_store; \
    break; \
  case 'S': \
    pusharg_short(rstack(0), 3); pop(1); func = jshort_reify_field_store; \
    break; \
  case 'I': \
    pusharg_int(rstack(0), 3); pop(1); func = jint_reify_field_store; \
    break; \
  case 'J': \
    pusharg_long(stack_long(0), 3); pop(2); func = jlong_reify_field_store; \
    break; \
  case 'F': \
    pusharg_float(rstack(0), 3); pop(1); func = jfloat_reify_field_store; \
    break; \
  case 'D': \
    pusharg_double(stack_double(0), 3); pop(2); func = jdouble_reify_field_store; \
    break; \
  default: \
    ABORT(); \
  } \
  pusharg_ref_const(finfo.field, 2); \
  pusharg_ref_const(finfo.class, 1); \
  pusharg_ref((obj), 0); \
  call_soft(func); \
  popargs(); \
  fixup_function_call(); \
} while (0)

#define softcall_reify_array_load(obj, index, type, retto) do { \
  prepare_function_call(); \
  pusharg_int((index), 1); \
  pusharg_ref((obj), 0); \
  call_soft(j##type##_reify_array_load); \
  popargs(); \
  fixup_function_call(); \
  return_##type(retto); \
} while (0)

#define softcall_reify_array_store(obj, index, type, value) do { \
  prepare_function_call(); \
  pusharg_##type((value), 2); \
  pusharg_int((index), 1); \
  pusharg_ref((obj), 0); \
  call_soft(j##type##_reify_array_store); \
  popargs(); \
  fixup_function_call(); \
} while(0)

#define softcall_reify_arraylength(to, from) do { \
  prepare_function_call(); \
  pusharg_ref((from), 0); \
  call_soft(guarana_reify_arraylength); \
  popargs(); \
  fixup_function_call(); \
  return_int((to)); \
} while (0)

#endif /* GUARANA */

typedef struct _nativeCodeInfo {
	void*	mem;
	int	memlen;
	void*	code;
	int	codelen;
} nativeCodeInfo;

struct codeinfo;
void initInsnSequence(int, int, int);
void finishInsnSequence(struct codeinfo*, nativeCodeInfo*);
void installMethodCode(struct codeinfo*, Method*, nativeCodeInfo*);

typedef struct {
        bool BADARRAYINDEX;
        bool NULLPOINTER;
} jitflags;

extern jitflags willcatch;

#define	willCatch(FLAG)	willcatch. FLAG = true
#define	canCatch(FLAG)	willcatch. FLAG

#include "locks.h"
extern iLock translatorlock;

static inline void
enterTranslator(void)
{
	if (!staticLockIsInitialized(&translatorlock)) {
		initStaticLock(&translatorlock);
	}
	lockStaticMutex(&translatorlock);
}

static inline void
leaveTranslator(void)
{
	unlockStaticMutex(&translatorlock);
}

#endif
