/*
 * Decompiled with CFR 0.152.
 */
package kaffe.util;

public class IdentityHashtable {
    private transient Object[] keys;
    private transient Object[] elements;
    private transient float loadFactor;
    private int numberOfKeys;
    private transient int rehashLimit;
    private static final int DEFAULTCAPACITY = 101;
    private static final float DEFAULTLOADFACTOR = 0.75f;
    private static final Object removed = new Object();
    private static final Object free = null;

    public IdentityHashtable() {
        this(101, 0.75f);
    }

    public IdentityHashtable(int n) {
        this(n, 0.75f);
    }

    public IdentityHashtable(int n, float f) {
        if (n <= 0) {
            throw new Error("Initial capacity is <= 0");
        }
        if ((double)f <= 0.0) {
            throw new Error("Load Factor is <= 0");
        }
        this.loadFactor = f;
        this.keys = new Object[n];
        this.elements = new Object[n];
        this.numberOfKeys = 0;
        this.rehashLimit = (int)(f * (float)n);
    }

    public int size() {
        return this.numberOfKeys;
    }

    public boolean isEmpty() {
        return this.numberOfKeys == 0;
    }

    public synchronized boolean contains(Object object) {
        for (int i = this.elements.length - 1; i >= 0; --i) {
            if (!object.equals(this.elements[i])) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    private int calculateBucket(Object object) {
        return (System.identityHashCode(object) & Integer.MAX_VALUE) % this.keys.length;
    }

    public synchronized Object get(Object object) {
        int n = this.calculateBucket(object);
        int n2 = this.keys.length;
        for (int i = n; i < n2; ++i) {
            Object object2 = this.keys[i];
            if (object == object2) {
                return this.elements[i];
            }
            if (object2 != free) continue;
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Object object3 = this.keys[i];
            if (object == object3) {
                return this.elements[i];
            }
            if (object3 != free) continue;
            return null;
        }
        return null;
    }

    protected synchronized void rehash() {
        int n = this.keys.length * 2;
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.elements;
        this.keys = new Object[n];
        this.elements = new Object[n];
        this.rehashLimit = (int)(this.loadFactor * (float)n);
        this.numberOfKeys = 0;
        for (int i = objectArray.length - 1; i >= 0; --i) {
            if (objectArray[i] == free || objectArray[i] == removed) continue;
            this.put(objectArray[i], objectArray2[i]);
        }
    }

    public synchronized Object put(Object object, Object object2) {
        if (this.numberOfKeys >= this.rehashLimit) {
            this.rehash();
        }
        int n = this.calculateBucket(object);
        int n2 = this.keys.length;
        int n3 = -1;
        for (int i = n; i < n2; ++i) {
            Object object3 = this.keys[i];
            if (object == object3) {
                Object object4 = this.elements[i];
                this.elements[i] = object2;
                return object4;
            }
            if (object3 == removed) {
                if (n3 != -1) continue;
                n3 = i;
                continue;
            }
            if (object3 != free) continue;
            if (n3 == -1) {
                n3 = i;
            }
            this.keys[n3] = object;
            this.elements[n3] = object2;
            ++this.numberOfKeys;
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Object object5 = this.keys[i];
            if (object == object5) {
                Object object6 = this.elements[i];
                this.elements[i] = object2;
                return object6;
            }
            if (object5 == removed) {
                if (n3 != -1) continue;
                n3 = i;
                continue;
            }
            if (object5 != free) continue;
            if (n3 == -1) {
                n3 = i;
            }
            this.keys[n3] = object;
            this.elements[n3] = object2;
            ++this.numberOfKeys;
            return null;
        }
        if (n3 != -1) {
            this.keys[n3] = object;
            this.elements[n3] = object2;
            ++this.numberOfKeys;
            return null;
        }
        throw new Error("Inconsistent IdentityHashtable");
    }

    public synchronized Object remove(Object object) {
        int n = this.calculateBucket(object);
        int n2 = this.keys.length;
        for (int i = n; i < n2; ++i) {
            Object object2 = this.keys[i];
            if (object == object2) {
                Object object3 = this.elements[i];
                this.elements[i] = removed;
                this.keys[i] = removed;
                --this.numberOfKeys;
                return object3;
            }
            if (object2 != free) continue;
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Object object4 = this.keys[i];
            if (object == object4) {
                Object object5 = this.elements[i];
                this.elements[i] = removed;
                this.keys[i] = removed;
                --this.numberOfKeys;
                return object5;
            }
            if (object4 != free) continue;
            return null;
        }
        return null;
    }

    public synchronized void clear() {
        for (int i = this.keys.length - 1; i >= 0; --i) {
            this.keys[i] = free;
            this.elements[i] = free;
        }
        this.numberOfKeys = 0;
    }
}

