/*
 * Decompiled with CFR 0.152.
 */
package kaffe.io;

import java.io.UnsupportedEncodingException;
import kaffe.io.ConverterAlias;

public abstract class CharToByteConverter {
    protected char[] buf;
    protected int blen;
    private static String encodingRoot = "kaffe.io";
    private static String encodingDefault = System.getProperty("file.encoding");

    public void carry(char[] cArray, int n, int n2) {
        int n3 = this.blen + n2;
        if (cArray == this.buf && n == 0) {
            return;
        }
        if (this.buf == null) {
            int n4 = n2 < 128 ? 128 : n2;
            this.buf = new char[n4];
        } else if (n3 > this.buf.length) {
            int n5;
            for (n5 = this.buf.length * 2; n5 < n3; n5 *= 2) {
            }
            char[] cArray2 = new char[n5];
            System.arraycopy(this.buf, 0, cArray2, 0, this.blen);
            this.buf = cArray2;
        }
        System.arraycopy(cArray, n, this.buf, this.blen, n2);
        this.blen = n3;
    }

    public abstract int convert(char[] var1, int var2, int var3, byte[] var4, int var5, int var6);

    public int flush(byte[] byArray, int n, int n2) {
        if (this.blen == 0) {
            return 0;
        }
        int n3 = this.blen;
        this.blen = 0;
        return this.convert(this.buf, 0, n3, byArray, n, n2);
    }

    public static CharToByteConverter getConverter(String string) throws UnsupportedEncodingException {
        String string2 = ConverterAlias.alias(string);
        try {
            return (CharToByteConverter)Class.forName(String.valueOf(String.valueOf(encodingRoot).concat(String.valueOf(".CharToByte"))).concat(String.valueOf(string2))).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedEncodingException(string);
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedEncodingException(string);
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedEncodingException(string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedEncodingException(string);
        }
    }

    public static CharToByteConverter getDefault() {
        String string = encodingDefault;
        if (ClassLoader.getSystemResourceAsStream(String.valueOf(String.valueOf(encodingRoot).concat(String.valueOf(".CharToByte"))).concat(String.valueOf(string))) == null) {
            string = "Default";
        }
        try {
            return CharToByteConverter.getConverter(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public abstract int getNumberOfBytes(char[] var1, int var2, int var3);
}

