/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import kaffe.util.zip.SwitchInflater;

public class ZipInputStream
extends InflaterInputStream
implements ZipConstants {
    private byte[] sigbuf = new byte[4];
    private byte[] zheader = new byte[30];
    private boolean closed = false;
    private SwitchInflater sinf = (SwitchInflater)this.inf;

    public ZipInputStream(InputStream inputStream) {
        super(inputStream, new SwitchInflater(true, true));
    }

    public ZipEntry getNextEntry() throws IOException {
        this.closeEntry();
        ZipInputStream zipInputStream = this;
        synchronized (zipInputStream) {
            ZipEntry zipEntry;
            try {
                long l;
                while (true) {
                    if (this.readFully(this.sigbuf, 0, this.sigbuf.length) != this.sigbuf.length) {
                        throw new IOException("signature not found");
                    }
                    l = this.get32(this.sigbuf, 0);
                    if (l == 33639248L) {
                        ZipEntry zipEntry2 = null;
                        Object var8_6 = null;
                        return zipEntry2;
                    }
                    if (l != 134695760L) break;
                    this.skip(16 - this.sigbuf.length);
                }
                if (l != 67324752L || this.readFully(this.zheader, this.sigbuf.length, this.zheader.length - this.sigbuf.length) != this.zheader.length - this.sigbuf.length) {
                    throw new IOException(String.valueOf("LOC header signature bad: ").concat(String.valueOf(Long.toHexString(l))));
                }
                char[] cArray = new char[this.get16(this.zheader, 26)];
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = (char)this.read();
                }
                byte[] byArray = new byte[this.get16(this.zheader, 28)];
                this.readFully(byArray, 0, byArray.length);
                ZipEntry zipEntry3 = new ZipEntry(new String(cArray));
                zipEntry3.time = -1L;
                zipEntry3.crc = this.get32(this.zheader, 14);
                zipEntry3.size = (int)this.get32(this.zheader, 22);
                zipEntry3.method = this.get16(this.zheader, 8);
                zipEntry3.extra = byArray;
                zipEntry3.comment = "";
                zipEntry3.flag = (int)this.get32(this.zheader, 6);
                zipEntry3.version = this.get16(this.zheader, 4);
                zipEntry3.csize = (int)this.get32(this.zheader, 18);
                zipEntry3.offset = 0L;
                if (zipEntry3.method == 0) {
                    this.sinf.setMode(true);
                    this.sinf.setLength((int)zipEntry3.csize);
                } else {
                    this.sinf.setMode(false);
                }
                this.closed = false;
                zipEntry = zipEntry3;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                throw throwable;
            }
            Object var8_7 = null;
            return zipEntry;
        }
    }

    public void closeEntry() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.sinf.reset();
            this.sinf.setMode(true);
            this.sinf.setLength(Integer.MAX_VALUE);
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        return n3;
    }

    public long skip(long l) throws IOException {
        return super.skip(l);
    }

    public void close() throws IOException {
        this.closeEntry();
        super.close();
    }

    private int get16(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        return n2 |= (byArray[n + 1] & 0xFF) << 8;
    }

    private long get32(byte[] byArray, int n) {
        long l = (long)byArray[n] & 0xFFL;
        l |= ((long)byArray[n + 1] & 0xFFL) << 8;
        l |= ((long)byArray[n + 2] & 0xFFL) << 16;
        return l |= ((long)byArray[n + 3] & 0xFFL) << 24;
    }

    private int readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        while (n2 > 0 && (n3 = this.read(byArray, n, n2)) != -1) {
            n4 += n3;
            n += n3;
            n2 -= n3;
        }
        return n4;
    }
}

