/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import kaffe.util.Ptr;

public class ZipFile
implements ZipConstants {
    private String name;
    private Ptr zip;

    public ZipFile(String string) throws IOException {
        this.name = string;
        this.zip = ZipFile.openZipFile0(string);
        if (this.zip == null) {
            throw new IOException(String.valueOf("No such zip file ").concat(String.valueOf(string)));
        }
    }

    public ZipFile(File file) throws ZipException, IOException {
        this(file.getPath());
    }

    public void close() throws IOException {
        if (this.zip != null) {
            ZipFile.closeZipFile0(this.zip);
            this.zip = null;
        }
    }

    public Enumeration entries() {
        Vector vector = ZipFile.getZipEntries0(this.zip);
        return vector.elements();
    }

    public ZipEntry getEntry(String string) {
        return ZipFile.getZipEntry0(this.zip, string);
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        byte[] byArray = ZipFile.getZipData0(this.zip, zipEntry);
        if (byArray == null) {
            throw new ZipException("no data");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return byteArrayInputStream;
    }

    public String getName() {
        return this.name;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static native Ptr openZipFile0(String var0);

    private static native void closeZipFile0(Ptr var0);

    private static native ZipEntry getZipEntry0(Ptr var0, String var1);

    private static native Vector getZipEntries0(Ptr var0);

    private static native byte[] getZipData0(Ptr var0, ZipEntry var1);
}

