/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

public class Deflater {
    public static final int DEFLATED = 8;
    public static final int NO_COMPRESSION = 0;
    public static final int BEST_SPEED = 1;
    public static final int BEST_COMPRESSION = 9;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int FILTERED = 1;
    public static final int HUFFMAN_ONLY = 2;
    public static final int DEFAULT_STRATEGY = 0;
    private int strm;
    private byte[] buf;
    private int off;
    private int len;
    private int level;
    private int strategy;
    private boolean setParams;
    private boolean finish;
    private boolean finished;

    public Deflater(int n, boolean bl) {
        this.level = n;
        this.buf = null;
        this.len = 0;
        this.off = 0;
        this.strategy = 8;
        this.setParams = false;
        this.finish = false;
        this.finished = false;
        this.init(bl);
    }

    public Deflater(int n) {
        this(n, false);
    }

    public Deflater() {
        this(-1, false);
    }

    public synchronized void setInput(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.off = n;
        this.len = n2;
    }

    public void setInput(byte[] byArray) {
        this.setInput(byArray, 0, byArray.length);
    }

    public void setDictionary(byte[] byArray) {
        this.setDictionary(byArray, 0, byArray.length);
    }

    public synchronized void setStrategy(int n) {
        if (n != 8) {
            throw new IllegalArgumentException("only support deflation");
        }
        this.strategy = n;
    }

    public synchronized void setLevel(int n) {
        if (n < 0 || n > 9) {
            throw new IllegalArgumentException("levels 0-9 supported");
        }
        this.level = n;
    }

    public boolean needsInput() {
        return this.len == 0;
    }

    public synchronized void finish() {
        this.finish = true;
    }

    public synchronized boolean finished() {
        return this.finished;
    }

    public int deflate(byte[] byArray) {
        return this.deflate(byArray, 0, byArray.length);
    }

    protected void finalize() {
        this.end();
    }

    public synchronized native void setDictionary(byte[] var1, int var2, int var3);

    public synchronized native int deflate(byte[] var1, int var2, int var3);

    public synchronized native int getAdler();

    public synchronized native int getTotalIn();

    public synchronized native int getTotalOut();

    public synchronized native void reset();

    public synchronized native void end();

    private synchronized native void init(boolean var1);

    static {
        System.loadLibrary("zip");
    }
}

