/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Vector
extends AbstractList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -2767605614048989439L;
    protected int capacityIncrement;
    protected int elementCount;
    protected Object[] elementData;

    public Vector() {
        this(10, 0);
    }

    public Vector(int n) {
        this(n, 0);
    }

    public Vector(int n, int n2) {
        this.elementData = new Object[n];
        this.elementCount = 0;
        this.capacityIncrement = n2;
    }

    public final synchronized void addElement(Object object) {
        if (this.elementCount == this.elementData.length) {
            this.increaseCapacity();
        }
        this.elementData[this.elementCount++] = object;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public synchronized Object clone() {
        try {
            Vector vector = (Vector)super.clone();
            vector.elementData = (Object[])this.elementData.clone();
            return vector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public final synchronized void copyInto(Object[] objectArray) {
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
    }

    public synchronized Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        this.copyInto(objectArray);
        return objectArray;
    }

    public synchronized Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.elementCount) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.elementCount);
        }
        this.copyInto(objectArray);
        int n = objectArray.length;
        while (n-- > this.elementCount) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    public final synchronized Object elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(Integer.toString(n)).concat(String.valueOf(" >= "))).concat(String.valueOf(this.elementCount)));
        }
        return this.elementData[n];
    }

    public final synchronized Enumeration elements() {
        return new Enumerator();
    }

    public final synchronized void ensureCapacity(int n) {
        if (this.elementData.length < n) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[n];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized Object firstElement() {
        if (this.elementCount <= 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public Object get(int n) {
        return this.elementAt(n);
    }

    private void increaseCapacity() {
        int n = this.elementData.length;
        n = this.capacityIncrement > 0 ? (n += this.capacityIncrement) : (n == 0 ? 10 : (n *= 2));
        Object[] objectArray = this.elementData;
        this.elementData = new Object[n];
        System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
    }

    public final int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public final synchronized int indexOf(Object object, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            Object object2 = this.elementData[i];
            if (object != object2 && !object.equals(object2)) continue;
            return i;
        }
        return -1;
    }

    public final synchronized void insertElementAt(Object object, int n) {
        if (this.elementCount == this.elementData.length) {
            this.increaseCapacity();
        }
        if (n > this.elementCount || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n < this.elementCount) {
            System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        }
        this.elementData[n] = object;
        ++this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final synchronized Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.size() - 1);
    }

    public final synchronized int lastIndexOf(Object object, int n) {
        for (int i = n; i >= 0; --i) {
            Object object2 = this.elementData[i];
            if (object != object2 && !object.equals(object2)) continue;
            return i;
        }
        return -1;
    }

    public synchronized Object remove(int n) {
        Object object = this.elementAt(n);
        this.removeElementAt(n);
        return object;
    }

    public final synchronized void removeAllElements() {
        for (int i = this.elementCount - 1; i >= 0; --i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public final synchronized boolean removeElement(Object object) {
        if (this.contains(object)) {
            this.removeElementAt(this.indexOf(object));
            return true;
        }
        return false;
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(this.elementData, n + 1, this.elementData, n, this.elementCount - n - 1);
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final synchronized void setElementAt(Object object, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.elementData[n] = object;
    }

    public final synchronized void setSize(int n) {
        this.ensureCapacity(n);
        this.elementCount = n;
    }

    public final int size() {
        return this.elementCount;
    }

    public final synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < this.elementCount; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.elementData[i].toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final synchronized void trimToSize() {
        if (this.elementCount != this.elementData.length) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    class Enumerator
    implements Enumeration {
        int index;

        public boolean hasMoreElements() {
            return this.index < Vector.this.elementCount;
        }

        public Object nextElement() {
            if (this.index >= Vector.this.elementCount) {
                throw new NoSuchElementException();
            }
            return Vector.this.elementData[this.index++];
        }

        Enumerator() {
        }
    }
}

