/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

public abstract class DateFormat
extends Format {
    private static final long serialVersionUID = 7218322306649953788L;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final int DEFAULT = 2;
    public static final int ERA_FIELD = 0;
    public static final int YEAR_FIELD = 1;
    public static final int MONTH_FIELD = 2;
    public static final int DATE_FIELD = 3;
    public static final int HOUR_OF_DAY1_FIELD = 4;
    public static final int HOUR_OF_DAY0_FIELD = 5;
    public static final int MINUTE_FIELD = 6;
    public static final int SECOND_FIELD = 7;
    public static final int MILLISECOND_FIELD = 8;
    public static final int DAY_OF_WEEK_FIELD = 9;
    public static final int DAY_OF_YEAR_FIELD = 10;
    public static final int DAY_OF_WEEK_IN_MONTH_FIELD = 11;
    public static final int WEEK_OF_YEAR_FIELD = 12;
    public static final int WEEK_OF_MONTH_FIELD = 13;
    public static final int AM_PM_FIELD = 14;
    public static final int HOUR1_FIELD = 15;
    public static final int HOUR0_FIELD = 16;
    public static final int TIMEZONE_FIELD = 17;
    protected Calendar calendar;
    protected NumberFormat format;
    private boolean lenient = true;

    protected DateFormat() {
    }

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object object) {
        try {
            DateFormat dateFormat = (DateFormat)object;
            if (this.calendar == dateFormat.calendar && this.format == dateFormat.format) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Date date = object instanceof Number ? new Date(((Number)object).intValue()) : (Date)object;
        return this.format(date, stringBuffer, fieldPosition);
    }

    public abstract StringBuffer format(Date var1, StringBuffer var2, FieldPosition var3);

    public final String format(Date date) {
        StringBuffer stringBuffer = this.format(date, new StringBuffer(), new FieldPosition(0));
        return stringBuffer.toString();
    }

    public static final DateFormat getDateInstance() {
        return DateFormat.getDateInstance(2, Locale.getDefault());
    }

    public static final DateFormat getDateInstance(int n) {
        return DateFormat.getDateInstance(n, Locale.getDefault());
    }

    public static final DateFormat getDateInstance(int n, Locale locale2) {
        ResourceBundle resourceBundle = Format.getResources("dateformat", locale2);
        String string = ((String[])resourceBundle.getObject("date"))[n];
        return new SimpleDateFormat(string, locale2);
    }

    public static final DateFormat getDateTimeInstance() {
        return DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(int n, int n2) {
        return DateFormat.getDateTimeInstance(n, n2, Locale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(int n, int n2, Locale locale2) {
        ResourceBundle resourceBundle = Format.getResources("dateformat", locale2);
        String string = ((String[])resourceBundle.getObject("date"))[n];
        String string2 = ((String[])resourceBundle.getObject("time"))[n2];
        return new SimpleDateFormat(String.valueOf(String.valueOf(string).concat(String.valueOf(" "))).concat(String.valueOf(string2)), locale2);
    }

    public static final DateFormat getTimeInstance() {
        return DateFormat.getTimeInstance(2, Locale.getDefault());
    }

    public static final DateFormat getTimeInstance(int n) {
        return DateFormat.getTimeInstance(n, Locale.getDefault());
    }

    public static final DateFormat getTimeInstance(int n, Locale locale2) {
        ResourceBundle resourceBundle = Format.getResources("dateformat", locale2);
        String string = ((String[])resourceBundle.getObject("time"))[n];
        return new SimpleDateFormat(string, locale2);
    }

    public static final DateFormat getInstance() {
        return DateFormat.getDateTimeInstance();
    }

    public NumberFormat getNumberFormat() {
        return this.format;
    }

    public TimeZone getTimeZone() {
        return this.calendar.getTimeZone();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public Date parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = this.parse(string, parsePosition);
        if (date == null) {
            throw new ParseException("", parsePosition.getIndex());
        }
        return date;
    }

    public abstract Date parse(String var1, ParsePosition var2);

    public Date parse(Object object, ParsePosition parsePosition) {
        return this.parse((String)object, parsePosition);
    }

    public static synchronized Locale[] getAvailableLocales() {
        return Format.getAvailableLocales("dateformat");
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.format = numberFormat;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.calendar.setTimeZone(timeZone);
    }
}

