/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import kaffe.net.DefaultURLStreamHandlerFactory;

public final class URL
implements Serializable {
    private static final long serialVersionUID = -7627629688361524110L;
    private static URLStreamHandlerFactory defaultFactory = new DefaultURLStreamHandlerFactory();
    private static URLStreamHandlerFactory factory;
    private URLStreamHandler handler;
    private String protocol;
    private String host;
    private int port;
    private String file;
    private String ref;
    private URLConnection conn;

    public URL(String string) throws MalformedURLException {
        int n = string.indexOf(58, 0);
        if (n == -1) {
            this.protocol = "file";
            this.host = "";
            this.port = -1;
            this.file = string;
        } else {
            int n2;
            int n3;
            this.protocol = string.substring(0, n);
            int n4 = n + 3;
            if (string.length() >= n4 && string.substring(n + 1, n4).equals("//")) {
                n3 = string.indexOf(58, n4);
                if (n3 != -1) {
                    this.host = string.substring(n4, n3);
                    int n5 = n3 + 1;
                    int n6 = string.indexOf(47, n5);
                    if (n6 == -1) {
                        n6 = string.length();
                    }
                    this.port = Integer.parseInt(string.substring(n5, n6));
                    n2 = string.indexOf(47, n4);
                } else {
                    n3 = string.indexOf(47, n4);
                    if (n3 != -1) {
                        this.host = string.substring(n4, n3);
                        this.port = -1;
                        n2 = string.indexOf(47, n4);
                    } else {
                        this.host = string.substring(n4);
                        this.port = -1;
                        n2 = -1;
                    }
                }
            } else {
                this.host = "";
                this.port = -1;
                n2 = n + 1;
            }
            if (n2 != -1) {
                this.file = string.substring(n2);
                n3 = this.file.lastIndexOf(35);
                if (n3 > -1) {
                    this.ref = this.file.substring(n3 + 1);
                    this.file = this.file.substring(0, n3);
                }
            } else {
                this.file = "";
            }
        }
        this.handler = URL.getURLStreamHandler(this.protocol);
    }

    public URL(String string, String string2, String string3) throws MalformedURLException {
        this(string, string2, -1, string3);
    }

    public URL(String string, String string2, int n, String string3) throws MalformedURLException {
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException();
        }
        this.protocol = string;
        this.host = string2;
        this.file = string3;
        this.port = n;
        this.handler = URL.getURLStreamHandler(string);
    }

    public URL(URL uRL, String string) throws MalformedURLException {
        this(string != null ? string : uRL.toString());
        if (string == null) {
            return;
        }
        if (uRL == null || !this.protocol.equals("file") || string.equals("file")) {
            return;
        }
        this.protocol = uRL.protocol;
        this.host = uRL.host;
        this.port = uRL.port;
        if (this.file.charAt(0) != '/') {
            int n = uRL.file.lastIndexOf(47);
            this.file = n == -1 ? String.valueOf(String.valueOf(uRL.file).concat(String.valueOf('/'))).concat(String.valueOf(this.file)) : (n == uRL.file.length() - 1 ? String.valueOf(uRL.file).concat(String.valueOf(this.file)) : String.valueOf(uRL.file.substring(0, n + 1)).concat(String.valueOf(this.file)));
        }
        this.handler = URL.getURLStreamHandler(this.protocol);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof URL)) {
            return false;
        }
        URL uRL = (URL)object;
        return this.protocol.equals(uRL.protocol) && this.host.equals(uRL.host) && this.port == uRL.port && this.file.equals(uRL.file) && (this.ref == null && uRL.ref == null || this.ref.equals(uRL.ref));
    }

    public final Object getContent() throws IOException {
        this.openConnection();
        return this.conn.getContent();
    }

    public String getFile() {
        return this.file;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRef() {
        return this.ref;
    }

    private static URLStreamHandler getURLStreamHandler(String string) throws MalformedURLException {
        URLStreamHandler uRLStreamHandler = null;
        if (factory != null && (uRLStreamHandler = factory.createURLStreamHandler(string)) != null) {
            return uRLStreamHandler;
        }
        uRLStreamHandler = defaultFactory.createURLStreamHandler(string);
        if (uRLStreamHandler != null) {
            return uRLStreamHandler;
        }
        throw new MalformedURLException(String.valueOf("unknown protocol: ").concat(String.valueOf(string)));
    }

    public int hashCode() {
        return this.protocol.hashCode() ^ this.host.hashCode() ^ this.file.hashCode();
    }

    public URLConnection openConnection() throws IOException {
        if (this.conn == null) {
            this.conn = this.handler.openConnection(this);
            this.conn.connect();
        }
        return this.conn;
    }

    public final InputStream openStream() throws IOException {
        if (this.conn == null) {
            this.openConnection();
        }
        return this.conn.getInputStream();
    }

    public boolean sameFile(URL uRL) {
        return this.protocol.equals(uRL.protocol) && this.host.equals(uRL.host) && this.port == uRL.port && this.file.equals(uRL.file);
    }

    protected void set(String string, String string2, int n, String string3, String string4) {
        this.protocol = string;
        this.host = string2;
        this.port = n;
        this.file = string3;
        this.ref = string4;
    }

    public static synchronized void setURLStreamHandlerFactory(URLStreamHandlerFactory uRLStreamHandlerFactory) {
        if (factory != null) {
            throw new Error("factory already set");
        }
        factory = uRLStreamHandlerFactory;
    }

    public String toExternalForm() {
        return this.handler.toExternalForm(this);
    }

    public String toString() {
        return this.toExternalForm();
    }
}

