/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;

public final class System {
    static final SecurityManager defaultSecurityManager;
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;
    private static Properties props;
    private static SecurityManager security;

    private System() {
    }

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    private static void checkPropertyAccess() {
        System.getSecurityManager().checkPropertiesAccess();
    }

    public static native long currentTimeMillis();

    public static void exit(int n) {
        Runtime.getRuntime().exit(n);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static Properties getProperties() {
        System.checkPropertyAccess();
        return props;
    }

    public static String getProperty(String string) {
        System.checkPropertyAccess();
        return System.getProperty(string, null);
    }

    public static String getProperty(String string, String string2) {
        System.checkPropertyAccess();
        return props.getProperty(string, string2);
    }

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static String getenv(String string) {
        throw new Error("System.getenv no longer supported");
    }

    public static native int identityHashCode(Object var0);

    private static native Properties initProperties(Properties var0);

    public static void load(String string) {
        Runtime.getRuntime().load(string);
    }

    public static void loadLibrary(String string) {
        Runtime.getRuntime().loadLibrary(string);
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    public static void runFinalizersOnExit(boolean bl) {
        Runtime.runFinalizersOnExit(bl);
    }

    private static native void setIn0(InputStream var0);

    private static native void setOut0(PrintStream var0);

    private static native void setErr0(PrintStream var0);

    public static void setErr(PrintStream printStream) {
        System.setErr0(printStream);
    }

    public static void setIn(InputStream inputStream) {
        System.setIn0(inputStream);
    }

    public static void setOut(PrintStream printStream) {
        System.setOut0(printStream);
    }

    public static void setProperties(Properties properties) {
        System.checkPropertyAccess();
        props = properties;
    }

    public static void setSecurityManager(SecurityManager securityManager) {
        if (security != defaultSecurityManager) {
            throw new SecurityException();
        }
        if (securityManager != null) {
            security = securityManager;
        }
    }

    static {
        security = defaultSecurityManager = new NullSecurityManager();
        props = System.initProperties(new Properties());
        in = new BufferedInputStream(new FileInputStream(FileDescriptor.in), 128);
        out = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out), 128), true);
        err = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.err), 128), true);
        try {
            Class.forName("java.util.SimpleTimeZone");
            Class.forName("java.util.GregorianCalendar");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

