/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.PipedWriter;
import java.io.Reader;

public class PipedReader
extends Reader {
    private static final int DEFAULT = 1024;
    private PipedWriter wr = null;
    private char[] buf = new char[1024];
    private int inpos = 0;
    private int outpos = 0;
    private int size = 0;

    public PipedReader() {
    }

    public PipedReader(PipedWriter pipedWriter) throws IOException {
        this.connect(pipedWriter);
    }

    public void connect(PipedWriter pipedWriter) throws IOException {
        if (this.wr != null || pipedWriter.rd != null) {
            throw new IOException("already connected");
        }
        this.wr = pipedWriter;
        this.wr.rd = this;
        this.lock = this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n3;
            try {
                while (this.size == 0) {
                    if (this.wr == null) {
                        return -1;
                    }
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                for (n3 = 0; n3 < n2 && this.size > 0; ++n3) {
                    cArray[n++] = this.buf[this.outpos++];
                    --this.size;
                    if (this.outpos != this.buf.length) continue;
                    this.outpos = 0;
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                throw throwable;
            }
            Object var8_8 = null;
            return n3;
        }
    }

    void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                for (int i = 0; i < n2; ++i) {
                    while (this.size >= this.buf.length) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.buf[this.inpos++] = cArray[n++];
                    ++this.size;
                    if (this.inpos != this.buf.length) continue;
                    this.inpos = 0;
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                throw throwable;
            }
        }
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.wr != null) {
                    this.wr.rd = null;
                    this.wr = null;
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }
}

