/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.Component;
import java.awt.Event;
import java.awt.event.InputEvent;

public class KeyEvent
extends InputEvent {
    protected int keyCode;
    protected char keyChar;
    private static final long serialVersionUID = -2352130953028126954L;
    public static final int KEY_FIRST = 400;
    public static final int KEY_LAST = 402;
    public static final int KEY_TYPED = 400;
    public static final int KEY_PRESSED = 401;
    public static final int KEY_RELEASED = 402;
    public static final int VK_ENTER = 10;
    public static final int VK_BACK_SPACE = 8;
    public static final int VK_TAB = 9;
    public static final int VK_CANCEL = 3;
    public static final int VK_CLEAR = 12;
    public static final int VK_SHIFT = 16;
    public static final int VK_CONTROL = 17;
    public static final int VK_ALT = 18;
    public static final int VK_PAUSE = 19;
    public static final int VK_CAPS_LOCK = 20;
    public static final int VK_ESCAPE = 27;
    public static final int VK_SPACE = 32;
    public static final int VK_PAGE_UP = 33;
    public static final int VK_PAGE_DOWN = 34;
    public static final int VK_END = 35;
    public static final int VK_HOME = 36;
    public static final int VK_LEFT = 37;
    public static final int VK_UP = 38;
    public static final int VK_RIGHT = 39;
    public static final int VK_DOWN = 40;
    public static final int VK_COMMA = 44;
    public static final int VK_PERIOD = 46;
    public static final int VK_SLASH = 47;
    public static final int VK_0 = 48;
    public static final int VK_1 = 49;
    public static final int VK_2 = 50;
    public static final int VK_3 = 51;
    public static final int VK_4 = 52;
    public static final int VK_5 = 53;
    public static final int VK_6 = 54;
    public static final int VK_7 = 55;
    public static final int VK_8 = 56;
    public static final int VK_9 = 57;
    public static final int VK_SEMICOLON = 59;
    public static final int VK_EQUALS = 61;
    public static final int VK_A = 65;
    public static final int VK_B = 66;
    public static final int VK_C = 67;
    public static final int VK_D = 68;
    public static final int VK_E = 69;
    public static final int VK_F = 70;
    public static final int VK_G = 71;
    public static final int VK_H = 72;
    public static final int VK_I = 73;
    public static final int VK_J = 74;
    public static final int VK_K = 75;
    public static final int VK_L = 76;
    public static final int VK_M = 77;
    public static final int VK_N = 78;
    public static final int VK_O = 79;
    public static final int VK_P = 80;
    public static final int VK_Q = 81;
    public static final int VK_R = 82;
    public static final int VK_S = 83;
    public static final int VK_T = 84;
    public static final int VK_U = 85;
    public static final int VK_V = 86;
    public static final int VK_W = 87;
    public static final int VK_X = 88;
    public static final int VK_Y = 89;
    public static final int VK_Z = 90;
    public static final int VK_OPEN_BRACKET = 91;
    public static final int VK_BACK_SLASH = 92;
    public static final int VK_CLOSE_BRACKET = 93;
    public static final int VK_NUMPAD0 = 96;
    public static final int VK_NUMPAD1 = 97;
    public static final int VK_NUMPAD2 = 98;
    public static final int VK_NUMPAD3 = 99;
    public static final int VK_NUMPAD4 = 100;
    public static final int VK_NUMPAD5 = 101;
    public static final int VK_NUMPAD6 = 102;
    public static final int VK_NUMPAD7 = 103;
    public static final int VK_NUMPAD8 = 104;
    public static final int VK_NUMPAD9 = 105;
    public static final int VK_MULTIPLY = 106;
    public static final int VK_ADD = 107;
    public static final int VK_SEPARATER = 108;
    public static final int VK_SUBTRACT = 109;
    public static final int VK_DECIMAL = 110;
    public static final int VK_DIVIDE = 111;
    public static final int VK_F1 = 112;
    public static final int VK_F2 = 113;
    public static final int VK_F3 = 114;
    public static final int VK_F4 = 115;
    public static final int VK_F5 = 116;
    public static final int VK_F6 = 117;
    public static final int VK_F7 = 118;
    public static final int VK_F8 = 119;
    public static final int VK_F9 = 120;
    public static final int VK_F10 = 121;
    public static final int VK_F11 = 122;
    public static final int VK_F12 = 123;
    public static final int VK_DELETE = 127;
    public static final int VK_NUM_LOCK = 144;
    public static final int VK_SCROLL_LOCK = 145;
    public static final int VK_PRINTSCREEN = 154;
    public static final int VK_INSERT = 155;
    public static final int VK_HELP = 156;
    public static final int VK_META = 157;
    public static final int VK_BACK_QUOTE = 192;
    public static final int VK_QUOTE = 222;
    public static final int VK_FINAL = 24;
    public static final int VK_CONVERT = 28;
    public static final int VK_NONCONVERT = 29;
    public static final int VK_ACCEPT = 30;
    public static final int VK_MODECHANGE = 31;
    public static final int VK_KANA = 21;
    public static final int VK_KANJI = 25;
    public static final int VK_UNDEFINED = 0;
    public static final char CHAR_UNDEFINED = '\uffff';

    public KeyEvent(Component component, int n, long l, int n2, int n3) {
        super(component, n);
        this.when = l;
        this.modifiers = n2;
        this.keyCode = n3;
        this.keyChar = (char)n3;
    }

    public KeyEvent(Component component, int n, long l, int n2, int n3, char c) {
        super(component, n);
        this.when = l;
        this.modifiers = n2;
        this.keyCode = n3;
        this.keyChar = c;
    }

    public char getKeyChar() {
        return this.keyChar;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public static String getKeyModifiersText(int n) {
        String string = "";
        int n2 = 0;
        if ((n & 4) != 0) {
            ++n2;
            string = String.valueOf(string).concat(String.valueOf("Meta"));
        }
        if ((n & 2) != 0) {
            if (n2++ > 0) {
                string = String.valueOf(string).concat(String.valueOf('+'));
            }
            string = String.valueOf(string).concat(String.valueOf("Ctrl"));
        }
        if ((n & 8) != 0) {
            if (n2++ > 0) {
                string = String.valueOf(string).concat(String.valueOf('+'));
            }
            string = String.valueOf(string).concat(String.valueOf("Alt"));
        }
        if ((n & 1) != 0) {
            if (n2++ > 0) {
                string = String.valueOf(string).concat(String.valueOf('+'));
            }
            string = String.valueOf(string).concat(String.valueOf("Shift"));
        }
        return string;
    }

    public static String getKeyText(int n) {
        if (n >= 48 && n <= 57 || n >= 65 && n <= 90 || n == 44 || n == 46 || n == 47 || n == 59 || n == 61 || n == 91 || n == 92 || n == 93) {
            return String.valueOf((char)n);
        }
        switch (n) {
            case 10: {
                return "Enter";
            }
            case 8: {
                return "Backspace";
            }
            case 9: {
                return "Tab";
            }
            case 3: {
                return "Cancel";
            }
            case 12: {
                return "Clear";
            }
            case 16: {
                return "Shift";
            }
            case 17: {
                return "Control";
            }
            case 18: {
                return "Alt";
            }
            case 19: {
                return "Pause";
            }
            case 20: {
                return "Caps Lock";
            }
            case 27: {
                return "Escape";
            }
            case 32: {
                return "Space";
            }
            case 33: {
                return "Page Up";
            }
            case 34: {
                return "Page Down";
            }
            case 35: {
                return "End";
            }
            case 36: {
                return "Home";
            }
            case 37: {
                return "Left";
            }
            case 38: {
                return "Up";
            }
            case 39: {
                return "Right";
            }
            case 40: {
                return "Down";
            }
            case 106: {
                return "NumPad *";
            }
            case 107: {
                return "NumPad +";
            }
            case 108: {
                return "NumPad ,";
            }
            case 109: {
                return "NumPad -";
            }
            case 110: {
                return "NumPad .";
            }
            case 111: {
                return "NumPad /";
            }
            case 112: {
                return "F1";
            }
            case 113: {
                return "F2";
            }
            case 114: {
                return "F3";
            }
            case 115: {
                return "F4";
            }
            case 116: {
                return "F5";
            }
            case 117: {
                return "F6";
            }
            case 118: {
                return "F7";
            }
            case 119: {
                return "F8";
            }
            case 120: {
                return "F9";
            }
            case 121: {
                return "F10";
            }
            case 122: {
                return "F11";
            }
            case 123: {
                return "F12";
            }
            case 127: {
                return "Delete";
            }
            case 144: {
                return "Num Lock";
            }
            case 145: {
                return "Scroll Lock";
            }
            case 154: {
                return "Print Screen";
            }
            case 155: {
                return "Insert";
            }
            case 156: {
                return "Help";
            }
            case 157: {
                return "Meta";
            }
            case 192: {
                return "Back Quote";
            }
            case 222: {
                return "Quote";
            }
            case 24: {
                return "Final";
            }
            case 28: {
                return "Convert";
            }
            case 29: {
                return "No Convert";
            }
            case 30: {
                return "Accept";
            }
            case 31: {
                return "Mode Change";
            }
            case 21: {
                return "Kana";
            }
            case 25: {
                return "Kanji";
            }
        }
        if (n >= 96 && n <= 105) {
            return String.valueOf("NumPad-").concat(String.valueOf((char)(n - 96 + 48)));
        }
        return String.valueOf("Unknown keyCode: 0x").concat(String.valueOf(Integer.toString(n, 16)));
    }

    protected Event initOldEvent(Event event) {
        if (this.keyChar == '\u0000') {
            return null;
        }
        event.target = this.source;
        event.id = this.id;
        event.when = this.when;
        event.modifiers = this.modifiers;
        event.key = this.keyChar;
        return event;
    }

    public boolean isActionKey() {
        int n = this.keyCode;
        if (n >= 19 && n <= 20) {
            return true;
        }
        if (n >= 33 && n <= 40) {
            return true;
        }
        if (n >= 112 && n <= 123) {
            return true;
        }
        return n >= 144 && n <= 155;
    }

    public String paramString() {
        String string;
        int n = this.keyCode;
        char c = this.keyChar;
        switch (this.id) {
            case 401: {
                string = "KEY_PRESSED";
                break;
            }
            case 402: {
                string = "KEY_RELEASED";
                break;
            }
            case 400: {
                string = "KEY_TYPED";
                break;
            }
            default: {
                string = "unknown type";
            }
        }
        string = String.valueOf(string).concat(String.valueOf(String.valueOf(",keyCode=").concat(String.valueOf(this.keyCode))));
        string = this.isActionKey() || n == 10 || n == 8 || n == 9 || n == 27 || n == 127 || n >= 96 && n <= 105 ? String.valueOf(string).concat(String.valueOf(String.valueOf(',').concat(String.valueOf(KeyEvent.getKeyText(n))))) : (c == '\n' || c == '\b' || c == '\t' || c == '\u001b' || c == '\u007f' ? String.valueOf(string).concat(String.valueOf(String.valueOf(',').concat(String.valueOf(KeyEvent.getKeyText(c))))) : String.valueOf(string).concat(String.valueOf(String.valueOf(String.valueOf(",keyChar='").concat(String.valueOf(this.keyChar))).concat(String.valueOf("'")))));
        if (this.modifiers > 0) {
            string = String.valueOf(string).concat(String.valueOf(String.valueOf(",modifiers=").concat(String.valueOf(KeyEvent.getKeyModifiersText(this.modifiers)))));
        }
        return string;
    }

    public void setKeyChar(char c) {
        this.keyChar = c;
    }

    public void setKeyCode(int n) {
        this.keyCode = n;
    }

    public void setModifiers(int n) {
        this.modifiers = n;
    }
}

