/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.NativeSelection$7$;
import java.awt.NativeSelection$9$;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import kaffe.awt.FlavorConverter;
import kaffe.awt.ObjectSelection;
import kaffe.awt.SerializerConverter;

class NativeSelection
implements Transferable {
    byte[] data;
    String mimeType;
    DataFlavor[] flavors;
    FlavorConverter[] converters;
    static DataFlavor[] textFlavors = new DataFlavor[2];
    static FlavorConverter[] textConverters;
    static DataFlavor[] objectFlavors;
    static FlavorConverter[] objectConverters;

    NativeSelection(String string, byte[] byArray) {
        this.mimeType = string;
        this.data = byArray;
        this.setFlavors();
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        for (int i = 0; i < this.flavors.length; ++i) {
            if (!this.flavors[i].equals(dataFlavor)) continue;
            return this.converters[i].importBytes(this.data);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (int i = 0; i < this.flavors.length; ++i) {
            if (!this.flavors[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    void setFlavors() {
        if (this.mimeType.startsWith("text/plain")) {
            this.flavors = textFlavors;
            this.converters = textConverters;
        } else if (this.mimeType.startsWith("application/x-java-serialized-object")) {
            this.flavors = objectFlavors;
            this.converters = objectConverters;
        } else {
            this.flavors = new DataFlavor[0];
            this.converters = new FlavorConverter[0];
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("NativeSelection [length: ");
        stringBuffer.append(this.data.length);
        stringBuffer.append(", ");
        for (n = 0; n < 8 && n < this.data.length; ++n) {
            stringBuffer.append(Integer.toHexString(this.data[n] & 0xFF));
            stringBuffer.append(' ');
        }
        if (n < this.data.length) {
            stringBuffer.append("...");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    static {
        NativeSelection.textFlavors[0] = DataFlavor.stringFlavor;
        NativeSelection.textFlavors[1] = DataFlavor.plainTextFlavor;
        textConverters = new FlavorConverter[2];
        NativeSelection.textConverters[0] = new 7$$anonymous_class6();
        NativeSelection.textConverters[1] = new 9$$anonymous_class8();
        objectFlavors = new DataFlavor[1];
        NativeSelection.objectFlavors[0] = ObjectSelection.objectFlavor;
        objectConverters = new FlavorConverter[1];
        NativeSelection.objectConverters[0] = new SerializerConverter();
    }
}

