/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class FlowLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -7262534875583282631L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    int align;
    int hgap;
    int vgap;

    public FlowLayout() {
        this(1, 5, 5);
    }

    public FlowLayout(int n) {
        this(n, 5, 5);
    }

    public FlowLayout(int n, int n2, int n3) {
        this.align = n;
        this.hgap = n2;
        this.vgap = n3;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    private int alignComps(Container container, int n, int n2, int n3, int n4) {
        Insets insets = container.getInsets();
        int n5 = container.width - insets.left - insets.right;
        int n6 = 0;
        int n7 = this.align == 1 ? insets.left + (n5 - n3) / 2 : (this.align == 2 ? n5 - n3 : insets.left + this.hgap);
        for (int i = n; i <= n2; ++i) {
            Component component = container.getComponent(i);
            if (component.height > n6) {
                n6 = component.height;
            }
            component.setLocation(n7, n4);
            n7 += component.width + this.hgap;
        }
        return n6 + this.vgap;
    }

    public int getAlignment() {
        return this.align;
    }

    public int getHgap() {
        return this.hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.width - insets.left - insets.right;
        int n2 = this.hgap;
        int n3 = this.vgap + insets.top;
        int n4 = 0;
        int n5 = container.getComponentCount();
        for (int i = 0; i < n5; ++i) {
            Component component = container.getComponent(i);
            if ((component.flags & 1) == 0) continue;
            component.setSize(component.getPreferredSize());
            if (n2 + component.width + this.hgap <= n) {
                n2 += component.width + this.hgap;
                continue;
            }
            if (i == n4) {
                component.setBounds(insets.left + this.hgap, n3, n - 2 * this.hgap, component.height);
                ++n4;
                n3 += component.height + this.vgap;
            } else {
                n3 += this.alignComps(container, n4, i - 1, n2, n3);
                n4 = i--;
            }
            n2 = this.hgap;
        }
        this.alignComps(container, n4, n5 - 1, n2, n3);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredSize(container, true);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.preferredSize(container, false);
    }

    private Dimension preferredSize(Container container, boolean bl) {
        Serializable serializable;
        int n = 0;
        int n2 = 0;
        int n3 = container.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            serializable = container.getComponent(i);
            if ((((Component)serializable).flags & 1) == 0) continue;
            Dimension dimension = bl ? ((Component)serializable).getMinimumSize() : ((Component)serializable).getPreferredSize();
            n += dimension.width + this.hgap;
            if (n2 >= dimension.height) continue;
            n2 = dimension.height;
        }
        serializable = container.getInsets();
        return new Dimension(n += ((Insets)serializable).left + ((Insets)serializable).right + this.hgap, n2 += ((Insets)serializable).top + ((Insets)serializable).bottom + 2 * this.vgap);
    }

    public void removeLayoutComponent(Component component) {
    }

    public void setAlignment(int n) {
        this.align = n;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.getClass().getName()).concat(String.valueOf(",vgap="))).concat(String.valueOf(this.vgap))).concat(String.valueOf(",hgap="))).concat(String.valueOf(this.hgap))).concat(String.valueOf(",align="));
        switch (this.align) {
            case 0: {
                string = String.valueOf(string).concat(String.valueOf("left"));
                break;
            }
            case 1: {
                string = String.valueOf(string).concat(String.valueOf("center"));
                break;
            }
            case 2: {
                string = String.valueOf(string).concat(String.valueOf("right"));
            }
        }
        return string;
    }
}

