/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.ClassProperties;
import java.lang.reflect.Method;
import java.util.Hashtable;

class ClassAnalyzer {
    static Hashtable dict = new Hashtable();
    static Class[] sig_AWTEvent = new Class[]{Class.forName("java.awt.AWTEvent")};
    static Class[] sig_Event = new Class[]{Class.forName("java.awt.Event")};
    static Class[] sig_Event_Object = new Class[]{Class.forName("java.awt.Event"), Class.forName("java.lang.Object")};
    static Class[] sig_Event_int = new Class[]{Class.forName("java.awt.Event"), Integer.TYPE};
    static Class[] sig_Event_int_int = new Class[]{Class.forName("java.awt.Event"), Integer.TYPE, Integer.TYPE};
    static String[] oldEventMethodName = new String[]{"handleEvent", "action", "keyDown", "keyUp", "mouseDown", "mouseUp", "mouseMove", "gotFocus", "lostFocus", "mouseEnter", "mouseExit", "mouseDrag", "postEvent"};
    static Class[][] oldEventMethodSig = new Class[][]{sig_Event, sig_Event_Object, sig_Event_int, sig_Event_int, sig_Event_int_int, sig_Event_int_int, sig_Event_int_int, sig_Event_Object, sig_Event_Object, sig_Event_int_int, sig_Event_int_int, sig_Event_int_int, sig_Event};

    static ClassProperties analyzeAll(Class clazz, boolean bl) {
        ClassProperties classProperties = (ClassProperties)dict.get(clazz);
        if (classProperties == null) {
            classProperties = new ClassProperties();
            classProperties.hasProcessEvent = ClassAnalyzer.checkProcessEvent(clazz);
            classProperties.useOldEvents = bl ? ClassAnalyzer.checkOldEventMethods(clazz) : false;
            classProperties.isNativeLike = bl;
            dict.put(clazz, classProperties);
        }
        return classProperties;
    }

    static ClassProperties analyzePostEvent(Class clazz) {
        ClassProperties classProperties = (ClassProperties)dict.get(clazz);
        if (classProperties == null) {
            classProperties = new ClassProperties();
            classProperties.useOldEvents = ClassAnalyzer.checkOldEventMenuMethods(clazz);
            classProperties.hasProcessEvent = false;
            classProperties.isNativeLike = false;
            dict.put(clazz, classProperties);
        }
        return classProperties;
    }

    static ClassProperties analyzeProcessEvent(Class clazz, boolean bl) {
        ClassProperties classProperties = (ClassProperties)dict.get(clazz);
        if (classProperties == null) {
            classProperties = new ClassProperties();
            classProperties.useOldEvents = false;
            classProperties.hasProcessEvent = ClassAnalyzer.checkProcessEvent(clazz);
            classProperties.isNativeLike = bl;
            dict.put(clazz, classProperties);
        }
        return classProperties;
    }

    static boolean checkOldEventMenuMethods(Class clazz) {
        try {
            Method method = clazz.getMethod("postEvent", sig_Event);
            if (method.getDeclaringClass() != Class.forName("java.awt.MenuComponent")) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(String.valueOf(String.valueOf("ouch!! ").concat(String.valueOf(clazz))).concat(String.valueOf(" has no postEvent")));
            return false;
        }
        return false;
    }

    static boolean checkOldEventMethods(Class clazz) {
        int n = 0;
        try {
            for (n = 0; n < oldEventMethodName.length; ++n) {
                Method method = clazz.getMethod(oldEventMethodName[n], oldEventMethodSig[n]);
                if (method.getDeclaringClass() == Class.forName("java.awt.Component")) continue;
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(String.valueOf(String.valueOf(String.valueOf("ouch!! ").concat(String.valueOf(clazz))).concat(String.valueOf(" has no "))).concat(String.valueOf(oldEventMethodName[n])));
            return false;
        }
        return false;
    }

    static boolean checkProcessEvent(Class clazz) {
        try {
            Method method = clazz.getDeclaredMethod("processEvent", sig_AWTEvent);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    ClassAnalyzer() {
    }
}

