// $Id: Compose.java,v 1.1 1998/05/29 16:07:02 oliva Exp $

/* Copyright 1998 Alexandre Oliva <oliva@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

import BR.unicamp.Guarana.*;

/**
 * This program shows how to use class MetaSequenceArray, that
 * implements a SequentialComposer delegating to an array of
 * MetaObjects.
 *
 * @author Alexandre Oliva
 * @version $Revision: 1.1 $
 */
public class Compose {
    public static void main(String[ ] argv) {
	Compose o = new Compose();
	MetaObject
	    a = new MetaLogger().setPrefix("a: "),
	    b = new MetaLogger().setPrefix("b: "),
	    mos[ ] = { a, b },
	    mo = new SequentialComposer(mos);
	Guarana.reconfigure(o, null, mo);
	o.another();
    }
    Compose another() {
	return new Compose();
    }
}
