// $Id: InstanceReconfigure.java,v 1.2 1998/05/08 15:50:07 oliva Exp $

/* Copyright 1997,1998 Alexandre Oliva <oliva@dcc.unicamp.br>
 *
 * See the files "COPYING" and "README" for information on usage and
 * redistribution of this file.  */

package BR.unicamp.Guarana;

/** This Message is used to control the reconfiguration of Objects
    whose meta-configuration is empty.  Whenever the Guarana kernel is
    asked to reconfigure an Object whose meta-configuration is empty,
    it creates an InstanceReconfigure Message and broadcasts it to all
    the classes the Object is an instance of, most derived first,
    java.lang.Object last.  Interfaces are excluded from this process.

    @author Alexandre Oliva
    @version $Revision: 1.2 $  */
public class InstanceReconfigure implements Message {
    /** The object whose meta-configuration is to be established.  */
    public final Object object;

    /** The primary MetaObject to be associated with the object.  */
    public MetaObject metaObject;

    /** Create an InstanceReconfigure Message, whose ultimate
	metaObject will be associated with the given Object.

	@param object the Object whose meta-configuration is to be
	established.

	@param metaObject the initially proposed primary MetaObject.
    */
    public InstanceReconfigure(final Object object,
			       final MetaObject metaObject) {
	this.object = object;
	this.metaObject = metaObject;
    }

    /** Obtains the Object whose meta-configuration is to be
	established.

	@return the base-level Object that is being reconfigured.  */
    public Object getObject() {
	return object;
    }

    /** Obtains the MetaObject that will become the primary MetaObject
	of the Object, unless it is changed.

	@return the currently selected MetaObject.  */
    public MetaObject getMetaObject() {
	return metaObject;
    }

    /** Changes the MetaObject that will become the Object's primary
	MetaObject.

	@param metaObject the new MetaObject.  */
    public synchronized void
	setMetaObject(final MetaObject metaObject) {
	this.metaObject = metaObject;
    }
}	
